/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.exec.test;

import com.kingdee.bos.ctrl.script.miniscript.MiniScriptEngine;
import com.kingdee.bos.ctrl.script.miniscript.ScriptResult;
import com.kingdee.bos.ctrl.script.miniscript.exec.IVarRequestor;
import com.kingdee.bos.ctrl.script.miniscript.exec.test.TestFuncall;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MiniScriptSample {
    public ScriptResult exec(String script, Map varMap) {
        try {
            ScriptResult res = MiniScriptEngine.exec(script, varMap);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String hello(String hello) {
        System.out.println("Call method hello:" + hello);
        return "[" + hello + "]";
    }

    public void testAssign() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", new Integer(100));
        String s = "a/=12; b='bb'; b+=a; System.out.println('OUT:a='+(++a));";
        this.exec(s, map);
    }

    public void testIf() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", new Integer(1));
        String s = "if(a>10){ System.out.println(a+'<10'); } else { System.out.println(a+'>=10'); }";
        s = s + "a=20;" + s;
        this.exec(s, map);
    }

    public void testFunction() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", "Hello,world!");
        map.put("obj", new MiniScriptSample());
        String s = "reMsg=obj.hello(msg); var myvar='I\\'m fine.';";
        ScriptResult res = this.exec(s, map);
        System.out.println("\u83b7\u53d6\u811a\u672c\u53d8\u91cf:\n\tmyvar=" + res.getVar("myvar") + "\n\treMsg=" + res.getVar("reMsg"));
    }

    public void testFunction2() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", "Hello,world!");
        map.put("s", new MiniScriptSample());
        String s = "b=s.hello(a); System.err.println(b.substring(1,6));";
        this.exec(s, map);
    }

    public void testLoop() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", new Integer(12));
        String s = "while(a-->0) System.out.println('############'.substring(0,a));";
        this.exec(s, map);
        s = "for(a=0;a<12;a++){ for(b=0;b<2;b++){System.out.print('------------'.substring(0,b));} System.out.println('############'.substring(0,a));}";
        this.exec(s, map);
    }

    public void testJava() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", "\u597d\u597d\u5b66\u4e60,\u5929\u5929\u5411\u4e0a");
        String s = "println('[MiniScript\u811a\u672c\u4e0ejava\u4ea4\u4e92\u6d4b\u8bd5]');runtime=runJava('\tJFrame frame=new javax.swing.JFrame();\tframe.setTitle((String)get(\"title\"));\tframe.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);\tset(\"ff\",frame);');";
        s = s + "frame=runtime.get('ff');";
        s = s + "frame.setBounds(100,100,400,300);";
        s = s + "frame.setVisible(true);";
        System.out.println(s);
        this.exec(s, map);
    }

    public void testClassObject() {
        HashMap<String, Class<Math>> map = new HashMap<String, Class<Math>>();
        map.put("math", Math.class);
        String s = "println(math.sin(45));";
        this.exec(s, map);
    }

    public void testDefineFunction() throws Exception {
        HashMap<String, Class<Math>> map = new HashMap<String, Class<Math>>();
        map.put("math", Math.class);
        String script = "function lg(v){\treturn math.log(v)/math.log(10);}println('lg(110)='+lg(110));";
        MiniScriptEngine.exec(script, map);
    }

    public void testDelegateInvoke() throws Exception {
        HashMap<String, TestFuncall> map = new HashMap<String, TestFuncall>();
        map.put("fun", new TestFuncall());
        String script = "println(fun.hello); println(fun.hi('hi,I\\'m superman!'));";
        MiniScriptEngine.exec(script, map);
    }

    public void testOutterObject() throws Exception {
        HashMap map = new HashMap();
        IVarRequestor requestor = new IVarRequestor(){

            @Override
            public boolean existVar(String name) {
                return true;
            }

            @Override
            public Object getVar(String name) {
                return "Try to get \"" + name + "\", this is return value.";
            }
        };
        String script = "println(obj.toString()+'\nVisit again:Length='+obj.length()); ";
        MiniScriptEngine.exec(script, map, requestor);
    }

    public void testNullCompare() throws Exception {
        HashMap map = new HashMap();
        String script = "println(v>2500)";
        MiniScriptEngine.exec(script, map);
    }

    public void testBigdecimal() throws Exception {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("a", new BigDecimal("123"));
        String script = "println(1/a*10.01d)";
        MiniScriptEngine.exec(script, map);
    }

    public static void main(String[] args) throws Exception {
        MiniScriptSample ss = new MiniScriptSample();
        ss.testBigdecimal();
    }
}

