/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.data.wizard.process.ProcessResource;
import com.kingdee.bos.ctrl.data.wizard.process.WizardContext;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class ProcessWizard
extends KDPanel
implements IWizardStep {
    protected WizardDialog.StepsManager manager;
    protected WizardContext context;
    protected KDLabel lbTitle;
    protected KDTextArea taStepDesc;
    protected KDPanel mainBodyPanel;

    protected abstract String getTitle();

    protected abstract String getStepDescription();

    protected abstract JComponent getMainBodyCtrl();

    public abstract IDataProcessModel getModel();

    public abstract void setModel(IDataProcessModel var1);

    protected boolean onGenerateScript(int processStep) {
        return false;
    }

    public ProcessWizard(WizardContext context) {
        this.context = context;
    }

    public JComponent getContent() {
        return this;
    }

    public boolean isReturnable() {
        return true;
    }

    public final void initStep(WizardDialog.StepsManager manager) {
        this.manager = manager;
        this.initCtrls(this.getTitle(), this.getStepDescription());
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        this.manager.setFinishEnabled(false);
        this.manager.setNextStepEnabled(true);
        this.manager.setPreviousStepEnabled(true);
    }

    public void destroy(boolean isFinished) {
    }

    protected void alert(String message) {
        MessageDialog.show((Component)((Object)this), (Object)message, (String)ProcessResource.getString("res_32"), (int)-1);
    }

    protected KDPanel makeSubTitlePanel(String title) {
        this.lbTitle = new KDLabel(title);
        KDSeparator sp = new KDSeparator();
        TableLayout layout = TableLayout.split((int)2, (int)1);
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)this.lbTitle, (Object)layout.cell(0));
        panel.add((Component)sp, (Object)layout.cell(1));
        return panel;
    }

    protected KDPanel makeDescPanel(String desc) {
        this.taStepDesc = new KDTextArea();
        if (desc != null) {
            this.taStepDesc.setText(desc);
        }
        this.taStepDesc.setEditable(false);
        this.taStepDesc.setBorder(null);
        this.taStepDesc.setFocusable(false);
        KDPanel panel = new KDPanel();
        panel.setBorder((Border)new TitledBorder(ProcessResource.getString("res_33")));
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)this.taStepDesc);
        return panel;
    }

    protected void updateTitle() {
        if (this.lbTitle != null) {
            this.lbTitle.setText(this.getTitle());
        }
    }

    protected void updateStepDesc() {
        if (this.taStepDesc != null) {
            this.taStepDesc.setText(this.getStepDescription());
        }
    }

    protected void initCtrls(String subTitle, String desc) {
        TableLayout layout = TableLayout.split((int)3, (int)1);
        layout.rowStyle(0).lockHeight(40);
        layout.rowStyle(1).setPriY(1);
        if (desc != null) {
            layout.rowStyle(2).lockHeight(100);
        }
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.makeSubTitlePanel(subTitle), layout.cell(0));
        if (desc != null) {
            this.add((Component)this.makeDescPanel(desc), layout.cell(2));
        }
        this.mainBodyPanel = new KDPanel((LayoutManager)new BorderLayout());
        this.add((Component)this.mainBodyPanel, layout.cell(1));
        this.mainBodyPanel.add((Component)this.getMainBodyCtrl(), (Object)"Center");
    }
}

