/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.rows.impl;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.ArrayWrapper;
import com.kingdee.bos.ctrl.common.util.WrapableArray;
import com.kingdee.bos.ctrl.data.engine.rows.IRowMetaData;
import com.kingdee.bos.ctrl.data.engine.rows.RowsException;
import com.kingdee.bos.ctrl.data.engine.rows.impl.ColumnInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

class SimpleRowsMetaData
implements IRowMetaData {
    private WrapableArray columns = new WrapableArray();
    private ArrayWrapper arrayWrapper = new ArrayWrapper();

    SimpleRowsMetaData() {
        this.arrayWrapper.wrap(this.columns).add(null);
    }

    SimpleRowsMetaData(ResultSet rs) throws RowsException {
        this();
        try {
            this.loadColumnInfoes(rs.getMetaData());
        }
        catch (SQLException sqlex) {
            throw new RowsException("Read resultset metadata failed. [detail]:" + sqlex.toString());
        }
    }

    private void loadColumnInfoes(ResultSetMetaData rsmd) throws SQLException, RowsException {
        this.arrayWrapper.wrap(this.columns);
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            int jdbcType = rsmd.getColumnType(i + 1);
            ColumnInfo column_info = new ColumnInfo(rsmd.getColumnName(i + 1), DataType.fromJdbcType((int)jdbcType), null);
            this.arrayWrapper.add((Object)column_info);
        }
    }

    @Override
    public int addColumn(int index, String name, DataType colType, HashMap extProps) throws RowsException {
        try {
            return this.getArrayWrapper().add(index, (Object)new ColumnInfo(name, colType, extProps));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RowsException("Bad index.");
        }
    }

    @Override
    public void deleteColumn(int index) throws RowsException {
        try {
            this.getArrayWrapper().remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RowsException("Bad index.");
        }
    }

    @Override
    public int getColumnCount() {
        return this.arrayWrapper.wrap(this.columns).size() - 1;
    }

    @Override
    public int find(String column) {
        this.arrayWrapper.wrap(this.columns);
        for (int i = 1; i < this.arrayWrapper.size(); ++i) {
            if (!((ColumnInfo)this.arrayWrapper.get((int)i)).columnName.equalsIgnoreCase(column)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataType getColumnType(int column) {
        return ((ColumnInfo)this.arrayWrapper.wrap((WrapableArray)this.columns).get((int)column)).colType;
    }

    @Override
    public String getName(int column) {
        return ((ColumnInfo)this.arrayWrapper.wrap((WrapableArray)this.columns).get((int)column)).columnName;
    }

    @Override
    public HashMap getProperties(int column) {
        return ((ColumnInfo)this.arrayWrapper.wrap(this.columns).get(column)).extendedProperties();
    }

    ArrayWrapper getArrayWrapper() {
        return this.arrayWrapper.wrap(this.columns);
    }
}

