/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.modal.io;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.modal.DataDef;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Import;
import com.kingdee.bos.ctrl.data.modal.Imports;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.ExecDefIO;
import com.kingdee.bos.ctrl.data.modal.io.ParameterIO;
import com.kingdee.bos.ctrl.data.modal.io.XmlTool;
import com.kingdee.bos.ctrl.data.modal.types.ScriptType;
import com.kingdee.bos.ctrl.data.modal.types.crosstab.CrosstabDef;
import com.kingdee.bos.ctrl.data.modal.types.crosstab.io.CrosstabDef2Xml;
import com.kingdee.bos.ctrl.data.modal.types.grouping.Grouping;
import com.kingdee.bos.ctrl.data.modal.types.grouping.io.Grouping2Xml;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.modal.types.rows.io.OutputColumns2Xml;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class DataDef2Xml {
    public static final Logger log = LogUtil.getPackageLogger(DataDef2Xml.class);
    public static HashMap outputDefRegistry = new HashMap();
    public static final String T_DATAOBJECT = "Data";
    public static final String T_PARAMETERS = "Parameters";
    public static final String T_PARAMETER = "Parameter";
    public static final String T_IMPORTS = "Imports";
    public static final String T_IMPORT = "Import";
    public static final String T_PROCCESSSCRIPT = "ProccessScript";
    public static final String T_OUTPUTS = "Outputs";
    public static final String T_DESIGN_INFOES = "DesignInfoes";
    public static final String T_DESIGN_INFO = "DesignInfo";
    public static final String A_VERSION = "version";
    public static final String A_NAME = "name";
    public static final String A_TYPE = "type";
    public static final String A_ALIAS = "alias";
    public static final String A_DESC = "desc";
    public static final String A_DATA_TYPE = "dataType";
    public static final String A_EXPR = "expr";
    public static final String A_SCRIPT_TYPE = "script-type";
    public static final String A_AUTO_MAKE_CALLING = "auto-make-calling";
    public static final String A_SCOPE = "scope";
    public static final String A_ALLOW_NULL = "allowNull";
    public static final String A_DEFAULT_VALUE = "defaultValue";
    public static final String A_INPUT_TYPE = "inputType";
    public static final String A_DESIGN_STEPS = "design_steps";

    public static final Element toXml(DataDef obj) {
        Element e = new Element(T_DATAOBJECT);
        DataDef2Xml.toXml(e, obj);
        XmlUtil.printElement((Element)e);
        return e;
    }

    public static final void toXml(Element e, DataDef obj) {
        Element designInfoes;
        Outputs outputs;
        ProcessScript script;
        Imports imports;
        if (obj == null) {
            return;
        }
        Def2Xml.makeDefObj((IDefObj)obj, (Element)e);
        List ps = obj.getParameters();
        if (ps != null && ps.size() > 0) {
            e.addContent((Content)ParameterIO.makeParameters((List)ps));
        }
        if ((imports = obj.getImports()) != null && imports.size() > 0) {
            e.addContent((Content)Imports2Xml.toXml(imports));
        }
        if ((script = obj.getProcessScript()) != null) {
            e.addContent((Content)ProcessScript2Xml.toXml(script));
        }
        if ((outputs = obj.getOutputs()) != null && outputs.size() > 0) {
            e.addContent((Content)Outputs2Xml.toXml(outputs));
        }
        if ((designInfoes = obj.getDesignInfoes()) != null) {
            e.addContent((Content)designInfoes.clone());
        }
    }

    static {
        outputDefRegistry.put(Grouping.class, Grouping2Xml.class);
        outputDefRegistry.put(OutputColumns.class, OutputColumns2Xml.class);
        outputDefRegistry.put(CrosstabDef.class, CrosstabDef2Xml.class);
    }

    public static final class ProcessScript2Xml {
        public static final Element toXml(ProcessScript ps) {
            Element e = new Element(DataDef2Xml.T_PROCCESSSCRIPT);
            if (ps != null) {
                Def2Xml.makeDefObj((IDefObj)ps, (Element)e);
                ScriptType st = ps.getType();
                if (st != null) {
                    e.setAttribute(DataDef2Xml.A_SCRIPT_TYPE, st.getName());
                }
                e.setAttribute(DataDef2Xml.A_AUTO_MAKE_CALLING, String.valueOf(ps.isAutoMakeCalling()));
                String text = ps.getScript();
                if (text != null) {
                    e.addContent((Content)new CDATA(text));
                }
            }
            return e;
        }
    }

    public static final class Imports2Xml {
        public static final Element toXml(Imports imports) {
            try {
                return XmlTool.list2Xml(DataDef2Xml.T_IMPORTS, imports, Import2Xml.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static final class Import2Xml {
            public static final Element toXml(Object o) {
                Map args;
                Import obj = (Import)((Object)o);
                Element e = new Element(DataDef2Xml.T_IMPORT);
                if (obj != null) {
                    Def2Xml.makeDefObj((IDefObj)obj, (Element)e);
                }
                if (obj.getExpr() != null) {
                    e.setAttribute(DataDef2Xml.A_EXPR, obj.getExpr());
                }
                if ((args = obj.getArgs()) != null) {
                    e.addContent((Content)ExecDefIO.makeArgs(args));
                }
                return e;
            }
        }
    }

    public static final class Outputs2Xml {
        public static final Element toXml(Outputs outputs) {
            Element e = new Element(DataDef2Xml.T_OUTPUTS);
            for (Object obj : outputs) {
                Element eChild = Outputs2Xml.output2Xml(obj);
                if (eChild == null) continue;
                e.addContent((Content)eChild);
            }
            return e;
        }

        public static final Element output2Xml(Object obj) {
            Class obj2XMLClass = (Class)outputDefRegistry.get(obj.getClass());
            try {
                Method obj2Xmler = obj2XMLClass.getMethod("toXml", Object.class);
                return (Element)obj2Xmler.invoke(null, obj);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
        }
    }
}

