/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.function;

import java.util.HashMap;

public class ArgsHelper {
    static final HashMap numberTypeSizes = new HashMap();
    static final HashMap classToSimpleNames = new HashMap();

    public static Number getNumber(double val, Class numberClass) {
        if (numberClass == Byte.class) {
            return new Byte((byte)val);
        }
        if (numberClass == Short.class) {
            return new Short((short)val);
        }
        if (numberClass == Integer.class) {
            return new Integer((int)val);
        }
        if (numberClass == Long.class) {
            return new Long((long)val);
        }
        if (numberClass == Float.class) {
            return new Float((float)val);
        }
        return new Double(val);
    }

    public static final boolean isIntegerLikedType(Class classsss) {
        return classsss == Byte.class || classsss == Integer.class || classsss == Short.class || classsss == Long.class;
    }

    public static final Class getBiggerType(Class class1, Class class2) {
        Number typeSize1 = (Number)numberTypeSizes.get(class1);
        Number typeSize2 = (Number)numberTypeSizes.get(class2);
        return typeSize1.byteValue() > typeSize2.byteValue() ? class1 : class2;
    }

    public static final Class getSmallerType(Class class1, Class class2) {
        Number typeSize1 = (Number)numberTypeSizes.get(class1);
        Number typeSize2 = (Number)numberTypeSizes.get(class2);
        return typeSize1.byteValue() < typeSize2.byteValue() ? class1 : class2;
    }

    public static final void checkNumericArgs(String funcName, Object[] args, int argCountDef) throws IllegalArgumentException {
        if (args == null) {
            return;
        }
        if (args.length != argCountDef) {
            throw new IllegalArgumentException("'" + funcName + "' + need " + argCountDef + " argument.");
        }
        for (int i = 0; i < argCountDef; ++i) {
            if (args[i] == null) {
                return;
            }
            if (Number.class.isAssignableFrom(args[i].getClass()) || Number.class.isAssignableFrom(args[i].getClass())) continue;
            throw new IllegalArgumentException("Type of " + funcName + " 's argment " + (i + 1) + " must be " + classToSimpleNames.get(Number.class));
        }
    }

    public static final void checkArgsType(String funcName, Object[] args, Class[] argsDefClasses) throws IllegalArgumentException {
        int argCountDef = argsDefClasses.length;
        if (args == null) {
            return;
        }
        if (args.length != argCountDef) {
            throw new IllegalArgumentException("'" + funcName + "' + need " + argCountDef + " argument.");
        }
        for (int i = 0; i < argCountDef; ++i) {
            if (args[i] == null) {
                return;
            }
            if (argsDefClasses[i].isAssignableFrom(args[i].getClass())) continue;
            throw new IllegalArgumentException("Type of " + funcName + " 's argment " + (i + 1) + " must be " + classToSimpleNames.get(argsDefClasses[i]));
        }
    }

    public static final void checkArgsCount(String name, Object[] args, int count) throws IllegalArgumentException {
        if (args != null ? args.length != count : count != 0) {
            throw new UnsupportedOperationException();
        }
    }

    public static final int intVal(Object numberObj) {
        return ((Number)numberObj).intValue();
    }

    public static final double doubleVal(Object numberObj) {
        return ((Number)numberObj).doubleValue();
    }

    public static final char charVal(Object charObj) {
        return ((Character)charObj).charValue();
    }

    public static final String stringVal(Object strObj) {
        return strObj.toString();
    }

    static {
        numberTypeSizes.put(Byte.class, new Byte(1));
        numberTypeSizes.put(Short.class, new Short(2));
        numberTypeSizes.put(Integer.class, new Integer(3));
        numberTypeSizes.put(Long.class, new Long(4L));
        numberTypeSizes.put(Float.class, new Float(5.0f));
        numberTypeSizes.put(Double.class, new Double(6.0));
        classToSimpleNames.put(Byte.class, "byte");
        classToSimpleNames.put(Short.class, "short");
        classToSimpleNames.put(Integer.class, "integer");
        classToSimpleNames.put(Long.class, "long");
        classToSimpleNames.put(Float.class, "float");
        classToSimpleNames.put(Double.class, "double");
        classToSimpleNames.put(Number.class, "number");
    }
}

