/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.data;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.data.modal.io.DataDef2Meta;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.fd2.util.DataUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ParamEditDialog
extends TypicalDialog
implements ItemListener {
    private KDTextField txtName;
    private KDComboBox cmbType;
    private KDComboBox cmbBindDs;
    private KDComboBox cmbBindField;
    private static String res = CtrlClassUtil.getPackageName(ParamEditDialog.class) + ".data";
    private boolean isFireCmbBindDS = true;

    public ParamEditDialog() {
    }

    public ParamEditDialog(Dialog owner) {
        super(owner);
    }

    public ParamEditDialog(Frame owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setTitle(ParamEditDialog.getMLS("paramTitle", "\u67e5\u8be2\u5bf9\u8c61\u95f4\u4f9d\u8d56\u5173\u7cfb"));
        this.txtName = new KDTextField();
        this.cmbType = new KDComboBox((Object[])new String[]{"String", "Number"});
        this.cmbBindDs = new KDComboBox();
        this.cmbBindField = new KDComboBox();
        this.txtName.setEnabled(false);
        this.cmbBindDs.addItemListener((ItemListener)this);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this.txtName, (String)ParamEditDialog.getMLS("colName", "\u53c2\u6570\u540d\u79f0"), (int)80);
        KDLabelContainer lbcType = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbType, (String)ParamEditDialog.getMLS("dataType", "\u6570\u636e\u7c7b\u578b"), (int)80);
        KDLabelContainer lbcBindDs = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindDs, (String)ParamEditDialog.getMLS("bindDs", "\u7ed1\u5b9a\u5bf9\u8c61"), (int)80);
        KDLabelContainer lbcBindField = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindField, (String)ParamEditDialog.getMLS("bindField", "\u7ed1\u5b9a\u5b57\u6bb5"), (int)80);
        TableLayout layoutBind = TableLayout.split((int)3, (int)1);
        layoutBind.style().setMargin(10, 20, 10, 10);
        layoutBind.defaultStyle().setHeight(19);
        layoutBind.rowStyle(0).setMarginBottom(3);
        layoutBind.rowStyle(2).setPriY(1);
        KDPanel panBind = new KDPanel((LayoutManager)layoutBind);
        panBind.setOpaque(false);
        panBind.setBorder((Border)BorderFactory.createTitledBorder(ParamEditDialog.getMLS("bind", "\u7ed1\u5b9a")));
        panBind.add((Component)lbcBindDs, (Object)layoutBind.cell(0));
        panBind.add((Component)lbcBindField, (Object)layoutBind.cell(1));
        Table tb = thisCell.split(4, 1);
        tb.rowStyle(0).setMarginBottom(3);
        tb.rowStyle(1).setMarginBottom(6);
        tb.rowStyle(2).setHeight(75);
        tb.rowStyle(3).setPriY(1);
        parent.add((Component)lbcName, tb.cell(0));
        parent.add((Component)lbcType, tb.cell(1));
        parent.add((Component)panBind, tb.cell(2));
        this.setSize(360, 210);
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    public void showValue(DSParam dsParam, IDataDef[] dss, IDataDef currentDs) {
        Iterator it;
        this.txtName.setText("");
        ArrayList<MetaClass> listMc = new ArrayList<MetaClass>();
        this.isFireCmbBindDS = false;
        for (int i = 0; i < dss.length; ++i) {
            if (dss[i] == currentDs) continue;
            MetaClass mc = DataDef2Meta.parseDataObject((IDataDef)dss[i]);
            this.cmbBindDs.addItem((Object)mc);
            listMc.add(mc);
        }
        this.cmbBindDs.setSelectedIndex(-1);
        this.isFireCmbBindDS = true;
        List parameters = currentDs.getParameters();
        if (parameters != null && (it = parameters.iterator()).hasNext()) {
            Parameter parameter = (Parameter)it.next();
            this.initNewParam(parameter);
        }
        if (dsParam != null && StringUtil.equals((String)this.txtName.getText(), (String)dsParam.getColName())) {
            this.txtName.setText(dsParam.getColName());
            this.cmbType.setSelectedItem((Object)dsParam.getDataType());
            MetaClass[] mcs = listMc.toArray(new MetaClass[0]);
            MetaClass mcSelected = DataUtil.getMetaClassById(mcs, dsParam.getAssociateSource());
            this.cmbBindDs.setSelectedItem((Object)mcSelected);
            MetaField mfSelected = null;
            if (mcSelected != null) {
                mfSelected = DataUtil.getColumnById(mcSelected, dsParam.getAssociateField());
            }
            this.cmbBindField.setSelectedItem(mfSelected);
        }
    }

    private void initNewParam(Parameter parameter) {
        this.txtName.setText(parameter.getName());
        if (DataType.isNumberType((DataType)parameter.getDataType())) {
            this.cmbType.setSelectedItem((Object)"Number");
        } else {
            this.cmbType.setSelectedItem((Object)"String");
        }
    }

    public DSParam getResultParam() {
        if (StringUtil.isEmptyString((String)this.txtName.getText())) {
            return null;
        }
        String colName = this.txtName.getText();
        String assDs = ((MetaClass)this.cmbBindDs.getSelectedItem()).getName();
        String assField = ((MetaField)this.cmbBindField.getSelectedItem()).getName();
        String dataType = this.cmbType.getSelectedItem().toString();
        DSParam param = new DSParam(colName, assDs, assField);
        param.setDataType(dataType);
        return param;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cmbBindDs) {
            if (!this.isFireCmbBindDS) {
                return;
            }
            MetaClass mc = (MetaClass)this.cmbBindDs.getSelectedItem();
            this.cmbBindField.addItems((Object[])mc.getFields().toArray(new MetaField[0]));
            this.cmbBindField.setSelectedIndex(-1);
        }
    }

    protected boolean verify() {
        if (StringUtil.isEmptyString((String)this.txtName.getText())) {
            WindowUtil.msgboxInfo((Object)ParamEditDialog.getMLS("noParamPrompt", "\u8be5\u67e5\u8be2\u5bf9\u8c61\u672a\u5b9a\u4e49\u7cfb\u7edf\u53c2\u6570\uff0c\u4e0d\u53ef\u4f5c\u7ed1\u5b9a\u5173\u7cfb\u3002"), (String)this.getTitle(), (Component)((Object)this));
            return true;
        }
        if (this.cmbBindDs.getSelectedIndex() < 0 || this.cmbBindField.getSelectedIndex() < 0) {
            WindowUtil.msgboxError((Object)ParamEditDialog.getMLS("noBoundPrompt", "\u7ed1\u5b9a\u76ee\u6807\u8f93\u5165\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002"), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }
}

