/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class KDFTreeSelectionModel
extends DefaultTreeSelectionModel {
    public static final int KDF_TREE_SELECTION = 8;

    public KDFTreeSelectionModel() {
        this.selectionMode = 4;
    }

    @Override
    public void setSelectionMode(int mode) {
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        TreePath[] newPaths = null;
        if (pPaths != null && pPaths.length > 0) {
            newPaths = this.kdfSelectedPath(pPaths);
        }
        super.setSelectionPaths(newPaths);
    }

    private TreePath[] kdfSelectedPath(TreePath[] pPaths) {
        if (pPaths[0].getPath().length <= 2) {
            TreePath[] newPaths = new TreePath[]{pPaths[0]};
            return newPaths;
        }
        int size = 1;
        for (int i = 1; i < pPaths.length; ++i) {
            if (!pPaths[i].getParentPath().equals(pPaths[0].getParentPath())) continue;
            ++size;
        }
        TreePath[] newPaths = new TreePath[size];
        int index = 0;
        for (int i = 0; i < pPaths.length; ++i) {
            if (!pPaths[i].getParentPath().equals(pPaths[0].getParentPath())) continue;
            newPaths[index++] = pPaths[i];
        }
        return newPaths;
    }

    private TreePath[] kdfSelectedPath(TreePath[] oldPaths, TreePath[] pPaths) {
        int i;
        TreePath[] newPaths = new TreePath[oldPaths.length + pPaths.length];
        for (i = 0; i < oldPaths.length; ++i) {
            newPaths[i] = oldPaths[i];
        }
        for (i = 0; i < pPaths.length; ++i) {
            newPaths[i + oldPaths.length] = pPaths[i];
        }
        return newPaths;
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        int oldCount = this.selection == null ? 0 : this.selection.length;
        TreePath[] newpaths = null;
        if (oldCount > 0) {
            if (paths != null && paths.length > 0) {
                newpaths = this.kdfSelectedPath(this.selection, paths);
                this.setSelectionPaths(newpaths);
            }
        } else {
            this.setSelectionPaths(paths);
        }
    }
}

