/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.undo;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.kdf.fd2.UndoOperation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;

public class InsertElementOperation
implements UndoOperation {
    private ReportElement element = null;
    private KDFFrame jrf = null;
    private String prompt = this.getMLS("add", "\u65b0\u589e");
    private static String res = CtrlClassUtil.getPackageName(InsertElementOperation.class) + ".undo";

    public InsertElementOperation(KDFFrame jrf, ReportElement element, String promptText) {
        this.element = element;
        this.jrf = jrf;
        this.prompt = promptText;
    }

    @Override
    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getSelectedElements().remove(this.element);
        this.element.delete();
        if (this.element.getTopContainer() != this.jrf.getCurrentPage()) {
            this.jrf.setCurrentpage(this.element.getTopContainer());
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.element, 1));
        this.jrf.getReportPanel().repaint();
    }

    @Override
    public void redo() {
        if (this.jrf == null) {
            return;
        }
        this.element.getParent().addElement(this.element);
        if (this.element.getTopContainer() != this.jrf.getCurrentPage()) {
            this.jrf.setCurrentpage(this.element.getTopContainer());
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.element, 2));
        this.jrf.setSelectedElement(this.element);
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return this.prompt;
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }
}

