/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.base;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.exception.HierarchyNoMemberException;
import com.kingdee.bos.olap.mdx.CacheType;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvaluatorImpl
implements Evaluator {
    private static final Logger logger = CommonLogger.getLogger(EvaluatorImpl.class);
    private final MdxQuery query;
    private final Cube cube;
    private final Connection connection;
    private Member[] currentMembers;
    private final Evaluator parent;
    private CellReader cellReader;
    private final int depth;
    private final Map expResultCache;
    private final Map expFactResultCache;
    private Member expandingMember;
    private boolean nonEmpty;
    private boolean nonFactEmpty;
    private int currentMemberLength;
    private Map dimensionOrdinal;
    private Member[] slicerMember;

    private EvaluatorImpl(Connection cn, MdxQuery query, Cube cube, CellReader cellReader, Evaluator parent, int depth, Map expResultCache, Map expFactResultCache) {
        this.cube = cube;
        this.query = query;
        this.connection = cn;
        this.cellReader = cellReader;
        this.parent = parent;
        this.depth = depth;
        this.expResultCache = expResultCache;
        this.expFactResultCache = expFactResultCache;
    }

    public EvaluatorImpl(Connection cn, MdxQuery query, Cube cube, CellReader cellReader) throws OLAPException {
        this(cn, query, cube, cellReader, null, 0, new HashMap(3, 2.0f), new HashMap(3, 2.0f));
        SchemaReader scr = this.connection.getSchemaReader();
        Dimension[] dimensions = cube.getDimensions();
        this.currentMembers = new Member[dimensions.length + 1];
        this.dimensionOrdinal = new HashMap();
        for (int i = 0; i < dimensions.length; ++i) {
            Dimension dimension = dimensions[i];
            int ordinal = dimension.getOrdinal(cube);
            this.dimensionOrdinal.put(dimension, new Integer(ordinal));
            Hierarchy hier = dimension.getDefaultHierarchy();
            Member member = scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw new HierarchyNoMemberException(hier);
            }
            this.currentMembers[ordinal] = member;
        }
        this.dimensionOrdinal.put(cube.getMeasureDimension(), new Integer(-1));
        this.currentMembers[dimensions.length] = cube.getMeasureDimension().getDefaultHierarchy().getDefaultMember();
        this.currentMemberLength = this.currentMembers.length;
    }

    private EvaluatorImpl(Connection cn, MdxQuery query, Cube cube, Member[] currentMembers, EvaluatorImpl parent) {
        this(cn, query, cube, parent.cellReader, parent, parent.depth + 1, parent.expResultCache, parent.expFactResultCache);
        this.currentMembers = currentMembers;
        this.dimensionOrdinal = parent.dimensionOrdinal;
        this.currentMemberLength = parent.currentMemberLength;
        this.slicerMember = parent.slicerMember;
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    @Override
    public Evaluator push(Member[] members) throws OLAPException {
        Evaluator evaluator = this.push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public Evaluator push() {
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        return new EvaluatorImpl(this.connection, this.query, this.cube, cloneCurrentMembers, this);
    }

    @Override
    public Evaluator push(Member member) throws OLAPException {
        Evaluator evaluator = this.push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public Evaluator pop() {
        return this.parent;
    }

    @Override
    public Member setContext(Member member) throws OLAPException {
        Member previous;
        Member m = member;
        if (m.isMeasure() || m.isMeasureProperty()) {
            previous = this.currentMembers[this.currentMemberLength - 1];
            this.currentMembers[this.currentMemberLength - 1] = m;
        } else {
            int ordinal = (Integer)this.dimensionOrdinal.get(m.getDimension());
            previous = this.currentMembers[ordinal];
            this.currentMembers[ordinal] = m;
        }
        return previous;
    }

    @Override
    public void setContext(Member[] members) throws OLAPException {
        this.setContextAsObject(members);
    }

    private void setContextAsObject(Object[] members) throws OLAPException {
        for (int i = 0; i < members.length; ++i) {
            Member member = (Member)members[i];
            if (member == null) continue;
            this.setContext(member);
        }
    }

    @Override
    public Member getContext(Dimension dimension) throws OLAPException {
        if (dimension.isMeasureDimension()) {
            return this.currentMembers[this.currentMemberLength - 1];
        }
        int ordinal = (Integer)this.dimensionOrdinal.get(dimension);
        return this.currentMembers[ordinal];
    }

    @Override
    public Object evaluateCurrent() throws OLAPException {
        Calc cellCalculation = this.query.getCellCalculation(this);
        if (cellCalculation != null) {
            return cellCalculation.evaluate(this);
        }
        Member maxSolveMember = this.getMaxSolveMember();
        if (maxSolveMember != null) {
            boolean cache;
            Member defaultMember = maxSolveMember.getHierarchy().getDefaultMember();
            EvaluatorImpl evaluator = (EvaluatorImpl)this.push(defaultMember);
            evaluator.setExpanding(maxSolveMember);
            Object o = null;
            Exp exp = null;
            CalculatedMember cMember = (CalculatedMember)maxSolveMember;
            boolean bl = cache = !cMember.getCacheType().equals(CacheType.NO);
            if (cache && (o = this.getCachedResult(exp = cMember.getExpression())) != null) {
                if (o == Util.nullValue) {
                    return null;
                }
                return o;
            }
            if (cMember.isNull()) {
                o = null;
            } else {
                exp = cMember.getExpression();
                Calc calc = this.query.compileExpression(exp, true);
                o = calc.evaluate(evaluator);
            }
            if (cache) {
                if (o == null) {
                    this.setCachedResult(exp, Util.nullValue);
                } else {
                    this.setCachedResult(exp, o);
                }
            }
            if (o == Util.nullValue) {
                return null;
            }
            return o;
        }
        for (int i = 0; i < this.currentMembers.length; ++i) {
            Exp exp = this.currentMembers[i].getExpression();
            if (exp == null) continue;
            Calc calc = this.query.compileExpression(exp, true);
            return calc.evaluate(this.push());
        }
        return this.cellReader.get(this);
    }

    private void setExpanding(Member member) throws OLAPException {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            EvaluatorImpl.checkRecursion((EvaluatorImpl)this.parent);
        }
    }

    private static void checkRecursion(EvaluatorImpl eval) throws OLAPException {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (EvaluatorImpl)eval.getParent();
        }
        block1: for (EvaluatorImpl eval2 = (EvaluatorImpl)eval.getParent(); eval2 != null; eval2 = (EvaluatorImpl)eval2.getParent()) {
            if (eval2.expandingMember != eval.expandingMember) continue;
            for (int i = 0; i < eval.currentMembers.length; ++i) {
                Member parentMember;
                Member member = eval2.currentMembers[i];
                if (member != null && member != (parentMember = eval.getContext(member.getDimension()))) continue block1;
            }
            throw new OLAPException("Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuffer sb = new StringBuffer("{");
        int frameCount = 0;
        for (EvaluatorImpl eval = this; eval != null; eval = (EvaluatorImpl)eval.getParent()) {
            if (eval.expandingMember == null) continue;
            if (frameCount++ > 0) {
                sb.append(", ");
            }
            sb.append("(");
            int memberCount = 0;
            for (int j = 0; j < eval.currentMembers.length; ++j) {
                Member m = eval.currentMembers[j];
                if (skipDefaultMembers && m == m.getHierarchy().getDefaultMember()) continue;
                if (memberCount++ > 0) {
                    sb.append(", ");
                }
                sb.append(m.getUniqueName());
            }
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    public Member getMaxSolveMember() {
        int maxSolve = Integer.MIN_VALUE;
        Member maxSolveMember = null;
        for (Member currentMember : this.currentMembers) {
            int solve;
            if (currentMember == null || !currentMember.isCalculated() || (solve = ((CalculatedMember)currentMember).getSolveOrder()) <= maxSolve) continue;
            maxSolve = solve;
            maxSolveMember = currentMember;
        }
        return maxSolveMember;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.connection.getSchemaReader();
    }

    private Object getExpResultCacheKey(Exp exp) {
        ArrayList<Serializable> key = new ArrayList<Serializable>();
        key.add(exp);
        for (int i = 0; i < this.currentMembers.length; ++i) {
            Dimension dim;
            Member member = this.currentMembers[i];
            if (member == null || !exp.dependsOn(dim = member.getDimension())) continue;
            key.add(this.currentMembers[i]);
        }
        return key;
    }

    @Override
    public Object getCachedResult(Exp exp) {
        Object key = this.getExpResultCacheKey(exp);
        return this.expResultCache.get(key);
    }

    @Override
    public void setCachedResult(Exp exp, Object result) {
        Object key = this.getExpResultCacheKey(exp);
        this.expResultCache.put(key, result);
    }

    public void clearExpResultCache(boolean clearFact) {
        this.expResultCache.clear();
        if (clearFact) {
            this.expFactResultCache.clear();
        }
    }

    @Override
    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public void setNonEmpty(boolean b) {
        this.nonEmpty = b;
    }

    @Override
    public boolean isNonFactEmpty() {
        return this.nonFactEmpty;
    }

    @Override
    public void setNonFactEmpty(boolean nonFactEmpty) {
        this.nonFactEmpty = nonFactEmpty;
    }

    @Override
    public Member[] getCurrentMembers() {
        return this.currentMembers;
    }

    @Override
    public MdxQuery getQuery() {
        return this.query;
    }

    @Override
    public boolean isRolap() {
        return this.connection.isRolap();
    }

    @Override
    public Member[] getSlicerMember() {
        return this.slicerMember;
    }

    public void setSlicerMember(Member[] slicerMember) {
        this.slicerMember = slicerMember;
    }

    public CellReader getCellReader() {
        return this.cellReader;
    }

    @Override
    public void setContext(Object o) throws OLAPException {
        if (o instanceof Member) {
            this.setContext((Member)o);
        } else if (o instanceof Object[]) {
            this.setContextAsObject((Member[])o);
        } else {
            throw Util.newInternal("can't go here");
        }
    }
}

