/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.dbsource;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.ConnectionHelper;
import com.kingdee.bos.olap.dbsource.DynamicTableSource;
import com.kingdee.bos.olap.dbsource.ResultSetTable;
import com.kingdee.bos.olap.dbsource.SqlWithParamTableDef;
import com.kingdee.bos.olap.dbsource.SqlWithParamTableSource;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.dbsource.TableDefTableSource;
import com.kingdee.bos.olap.dbsource.TableSource;
import com.kingdee.bos.olap.dbsource.TableSourceBase;
import com.kingdee.bos.olap.def.ConnectionDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.util.IgnoreCaseString;
import com.kingdee.bos.olap.util.SqlParamSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class TableManager {
    private static Logger log = CommonLogger.getLogger(TableManager.class);
    Connection conn;
    HashMap tables = new HashMap();

    public TableManager(TableDef[] tableDefs) {
        for (int i = 0; i < tableDefs.length; ++i) {
            this.addTable(tableDefs[i].name, new TableDefTableSource(this, tableDefs[i]));
        }
    }

    public TableManager(SchemaDef def, TableDef[] tableDefs) {
        int i;
        for (i = 0; i < tableDefs.length; ++i) {
            this.addTable(tableDefs[i].name, new TableDefTableSource(this, tableDefs[i]));
        }
        if (def.tables != null) {
            for (i = 0; i < def.tables.length; ++i) {
                TableDef t = def.tables[i];
                this.addTable(t);
            }
        }
        if (def.dimensions != null) {
            for (i = 0; i < def.dimensions.length; ++i) {
                this.useTable(def.dimensions[i].table);
            }
        }
        for (i = 0; i < def.cubes.length; ++i) {
            this.useTable(def.cubes[i].table);
        }
    }

    public TableManager(SchemaDef def, Map params) throws OLAPException, SQLException {
        int i;
        if (def.parameters != null) {
            for (i = 0; i < def.parameters.length; ++i) {
                ParameterDef param = def.parameters[i];
                Object x = params.get(param.name);
                if (x == null) {
                    x = params.get(new IgnoreCaseString(param.name));
                }
                if (x == null) {
                    throw new OLAPException("Parameter '" + param.name + "' has no data.");
                }
                if (!param.type.equalsIgnoreCase("Table")) continue;
                if (x instanceof Table) {
                    this.addTable(param.name, (Table)x);
                    continue;
                }
                if (x instanceof ResultSet) {
                    this.addTable(param.name, new ResultSetTable((ResultSet)x));
                    continue;
                }
                if (x instanceof String) {
                    this.addTable(param.name, new TableDefTableSource(this, new TableDef(param.name, (String)x)));
                    continue;
                }
                if (x instanceof TableDef) {
                    this.addTable(param.name, new TableDefTableSource(this, (TableDef)x));
                    continue;
                }
                if (x instanceof SqlWithParamTableDef) {
                    this.addTable(param.name, new SqlWithParamTableSource(this, (SqlWithParamTableDef)x));
                    continue;
                }
                throw new OLAPException("Parameter '" + param.name + "'  not a ResultSet or Table.");
            }
        }
        if (def.connection != null) {
            this.setConnection(def.connection);
        } else {
            Object conn = params.get("JdbcConnection");
            Object ds = params.get("JdbcDataSource");
            if (conn != null) {
                if (!(conn instanceof Connection)) {
                    throw new OLAPException("Jdbc Connection must be java.sql.Connection");
                }
                this.setConnection((Connection)conn);
            } else if (ds != null) {
                if (!(ds instanceof DataSource)) {
                    throw new OLAPException("Jdbc DataSource must be javax.sql.DataSource");
                }
                this.setConnection(((DataSource)ds).getConnection());
            }
        }
        if (def.tables != null) {
            for (i = 0; i < def.tables.length; ++i) {
                TableDef t = def.tables[i];
                this.addTable(t);
            }
        }
        if (def.dimensions != null) {
            for (i = 0; i < def.dimensions.length; ++i) {
                this.useTable(def.dimensions[i].table);
            }
        }
        for (i = 0; i < def.cubes.length; ++i) {
            this.useTable(def.cubes[i].table);
        }
    }

    public void clear() {
        Object[] names = this.tables.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            TableSourceBase ts = this.getTableSource((String)names[i]);
            if (ts == null) continue;
            ts.close();
        }
        this.tables.clear();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void setConnection(Connection cn) {
        this.conn = cn;
    }

    private void setConnection(ConnectionDef def) throws OLAPException {
        if (this.conn == null) {
            this.conn = ConnectionHelper.makeConnection(def);
        }
    }

    ResultSet executeQuery(String sql) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("No database connection.");
        }
        Statement stm = this.conn.createStatement();
        return stm.executeQuery(sql);
    }

    ResultSet executeQuery(String sql, SqlParamSet sps) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("No database connection.");
        }
        PreparedStatement ps = this.conn.prepareStatement(sql);
        sps.putToStatement(ps);
        return ps.executeQuery();
    }

    private void addTable(String name, Table table) {
        this.addTable(name, new TableSource(this, table));
    }

    private void addTable(TableDef def) {
        this.addTable(def.name, new TableDefTableSource(this, def));
    }

    private void addTable(String name, TableSourceBase source) {
        this.tables.put(name.toLowerCase(), source);
    }

    void useTable(String name) {
        this.getTableSource(name).addUse();
    }

    public void releaseTable(String name) {
        TableSourceBase source = this.getTableSource(name);
        if (source == null) {
            return;
        }
        if (source.release()) {
            this.tables.remove(name);
        }
    }

    private TableSourceBase getTableSource(String name) {
        TableSourceBase ts = (TableSourceBase)this.tables.get(name.toLowerCase());
        if (ts == null) {
            log.debug((Object)("create dynamic table source " + name));
            ts = new DynamicTableSource(this, name);
            this.tables.put(name.toLowerCase(), ts);
        }
        return ts;
    }

    public Table getTable(String name) throws SQLException, OLAPException {
        return this.getTableSource(name).get();
    }
}

