/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.def;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.CalculatedMemberDef;
import com.kingdee.bos.olap.def.CalculatedMemberPropertyDef;
import com.kingdee.bos.olap.def.ConnectionDef;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.PermissionDef;
import com.kingdee.bos.olap.def.PermissionItemDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.util.Util;
import java.util.HashSet;
import java.util.Hashtable;

public class SchemaChecker {
    SchemaDef schema;
    Hashtable tables = new Hashtable();
    Hashtable dims = new Hashtable();
    Hashtable cubes = new Hashtable();
    Hashtable rules = new Hashtable();
    Hashtable conns = new Hashtable();

    public SchemaChecker(SchemaDef _schema) {
        this.schema = _schema;
    }

    public void check() throws OLAPException {
        int i;
        if (this.schema.cubes == null || this.schema.cubes.length == 0) {
            throw new OLAPException("no cube defined.");
        }
        if (this.schema.parameters != null) {
            for (i = 0; i < this.schema.parameters.length; ++i) {
                this.checkParameter(this.schema.parameters[i]);
            }
        }
        if (this.schema.connection != null) {
            this.checkConnection(this.schema.connection);
        }
        if (this.schema.tables != null) {
            for (i = 0; i < this.schema.tables.length; ++i) {
                TableDef def = this.schema.tables[i];
                this.checkTable(def);
            }
        }
        if (this.schema.dimensions != null) {
            for (i = 0; i < this.schema.dimensions.length; ++i) {
                this.checkShareDimension(this.schema.dimensions[i]);
            }
        }
        if (this.schema.cubes == null || this.schema.cubes.length == 0) {
            throw new OLAPException(this.schema + " no cube defined.");
        }
        for (i = 0; i < this.schema.cubes.length; ++i) {
            this.checkCube(this.schema.cubes[i]);
        }
    }

    private void checkCube(CubeDef cube) throws OLAPException {
        if (cube.name == null) {
            throw new OLAPException("Cube name required.");
        }
        this.newCube(cube.name, cube);
        if (cube.table == null) {
            throw new OLAPException(cube + " property table required.");
        }
        if (cube.dimensions == null || cube.dimensions.length == 0) {
            throw new OLAPException(cube + " no dimension defined.");
        }
        Hashtable cdims = new Hashtable();
        if (cube.dimensions != null) {
            for (int i = 0; i < cube.dimensions.length; ++i) {
                CubeDimension dim = cube.dimensions[i];
                if (dim instanceof CubeDimensionDef) {
                    this.checkCubeDimension(cube, cdims, (CubeDimensionDef)dim);
                    continue;
                }
                this.checkDimensionUsage(cube, cdims, (DimensionUsageDef)dim);
            }
        }
        if (cube.measures == null || cube.measures.length == 0) {
            throw new OLAPException(cube + " no measure defined.");
        }
        Hashtable ht = new Hashtable();
        for (int i = 0; i < cube.measures.length; ++i) {
            this.checkMeasure(cube, ht, cube.measures[i]);
        }
        if (cube.calculatedMembers != null) {
            HashSet set = new HashSet();
            for (int i = 0; i < cube.calculatedMembers.length; ++i) {
                this.checkCalculatedMember(cube, set, cube.calculatedMembers[i]);
            }
        }
    }

    private void checkCalculatedMember(CubeDef cube, HashSet set, CalculatedMemberDef def) throws OLAPException {
        if (def.name == null || def.name == "") {
            throw new OLAPException(cube + " CalculatedMember name required.");
        }
        if (def.dimension == null || def.dimension == "") {
            throw new OLAPException(cube + " CalculatedMember " + def.name + " dimension required.");
        }
        String uniqueName = Util.implode(new String[]{def.dimension, def.name});
        if (!set.add(uniqueName)) {
            throw new OLAPException(cube + " CalculatedMember " + uniqueName + " required.");
        }
        if (def.formula == null || def.formula == "") {
            throw new OLAPException(cube + " CalculatedMember " + def.name + " formula required.");
        }
        if (!"Measures".equalsIgnoreCase(def.dimension) && !this.dims.containsKey(def.dimension)) {
            throw new OLAPException(cube + " CalculatedMember " + def.name + " " + def.dimension + "  Dimension not found.");
        }
        if (def.properties != null) {
            for (int i = 0; i < def.properties.length; ++i) {
                this.checkCalculatedMemberProperty(cube, uniqueName, def.properties[i]);
            }
        }
    }

    private void checkCalculatedMemberProperty(CubeDef cube, String uniqueName, CalculatedMemberPropertyDef def) throws OLAPException {
        if (def.name == null || def.name == "") {
            throw new OLAPException(cube + " CalculatedMember " + uniqueName + " property name required.");
        }
        if (def.value == null || def.value == "") {
            throw new OLAPException(cube + " CalculatedMember " + uniqueName + " property value required.");
        }
    }

    private void checkMeasure(CubeDef cube, Hashtable measures, MeasureDef measure) throws OLAPException {
        if (measure.name == null) {
            throw new OLAPException(cube + " Measure name required.");
        }
        if (measures.containsKey(measure.name)) {
            throw new OLAPException(cube + " " + measure + " redefined.");
        }
        measures.put(measure.name, measure);
        if (measure.column == null) {
            throw new OLAPException(cube + " " + measure + " no column defined.");
        }
        if (measure.permission != null) {
            this.checkPermission(measure.permission);
        }
    }

    private void checkDimensionUsage(CubeDef cube, Hashtable cdims, DimensionUsageDef dim) throws OLAPException {
        if (dim.name == null) {
            throw new OLAPException(cube + " DimensionUsage name required.");
        }
        if (!this.dims.containsKey(dim.name)) {
            throw new OLAPException(cube + " " + dim + "  Dimension not found.");
        }
        if (cdims.containsKey(dim.name)) {
            throw new OLAPException(cube + " " + dim + " redefined.");
        }
        cdims.put(dim.name, dim);
        if (dim.foreignKey == null) {
            throw new OLAPException(cube + " " + dim + " property foreignKey required.");
        }
    }

    private void checkCubeDimension(CubeDef cube, Hashtable cdims, CubeDimensionDef dim) throws OLAPException {
        if (dim.name == null) {
            throw new OLAPException(cube + " Dimension name required.");
        }
        if (cdims.containsKey(dim.name)) {
            throw new OLAPException(cube + " " + dim + " redefined.");
        }
        cdims.put(dim.name, dim);
        if (dim.type != null && !dim.type.equals("Standard") && !dim.type.equals("Time")) {
            throw new OLAPException(dim + " type must be Standard or Time.");
        }
        if (dim.hierarchies == null || dim.hierarchies.length == 0) {
            throw new OLAPException(dim + " no Hierarchy defined.");
        }
        for (int i = 0; i < dim.hierarchies.length; ++i) {
            Hashtable hies = new Hashtable();
            this.checkHierarchy(dim, hies, dim.hierarchies[i]);
        }
    }

    private void checkShareDimension(SharedDimensionDef dim) throws OLAPException {
        if (dim.name == null) {
            throw new OLAPException("Dimension name required.");
        }
        this.newDimension(dim.name, dim);
        if (dim.type != null && !dim.type.equals("Standard") && !dim.type.equals("Time")) {
            throw new OLAPException(dim + " type must be Standard or Time.");
        }
        if (dim.table == null) {
            throw new OLAPException(dim + " property table required.");
        }
        if (!this.tables.containsKey(dim.table)) {
            throw new OLAPException(dim + " table '" + dim.table + "' not found.");
        }
        if (dim.primaryKey == null) {
            throw new OLAPException(dim + " property primaryKey required.");
        }
        if (dim.hierarchies == null || dim.hierarchies.length == 0) {
            throw new OLAPException(dim + " no Hierarchy defined.");
        }
        for (int i = 0; i < dim.hierarchies.length; ++i) {
            Hashtable hies = new Hashtable();
            this.checkHierarchy(dim, hies, dim.hierarchies[i]);
        }
        if (dim.permission != null) {
            this.checkPermission(dim.permission);
        }
    }

    private void checkPermission(PermissionDef permission) throws OLAPException {
        if (permission.type == null) {
            throw new OLAPException("Permission property type required.");
        }
        if (!permission.type.equalsIgnoreCase("EAS")) {
            throw new OLAPException("Unknown Permission type '" + permission.type + "'.");
        }
        if (permission.items == null || permission.items.length == 0) {
            throw new OLAPException("Permission no PermissionItem defined.");
        }
        for (int i = 0; i < permission.items.length; ++i) {
            this.checkPermissionItem(permission.items[i]);
        }
    }

    private void checkPermissionItem(PermissionItemDef item) throws OLAPException {
        if (item.type == null) {
            throw new OLAPException("PermissionItem property type required.");
        }
        if (!item.type.equalsIgnoreCase("BOOLEAN") && !item.type.equalsIgnoreCase("SQL_FILTER")) {
            throw new OLAPException("Unknown PermissionItem type '" + item.type + "'.");
        }
        if (item.name == null) {
            throw new OLAPException("PermissionItem property name required");
        }
        if (item.type.equalsIgnoreCase("SQL_FILTER") && item.column == null) {
            throw new OLAPException("PermissionItem typed 'SQL_FILTER' require property column at the same time.");
        }
    }

    private void checkHierarchy(CubeDimension dim, Hashtable hies, HierarchyDef hie) throws OLAPException {
        if (hie.name != null) {
            if (hies.containsKey(hie.name)) {
                throw new OLAPException(dim + " " + hie + " redefined.");
            }
            hies.put(hie.name, hie);
        }
        if (hie.levels == null || hie.levels.length == 0) {
            throw new OLAPException(dim + " " + hie + " not level defined.");
        }
        for (int i = 0; i < hie.levels.length; ++i) {
            Hashtable levels = new Hashtable();
            this.checkLevel(dim, levels, hie.levels[i]);
        }
    }

    private void checkLevel(CubeDimension dim, Hashtable levels, LevelDef level) throws OLAPException {
        if (level.name == null) {
            throw new OLAPException(dim + " Level name required.");
        }
        if (level.column == null) {
            throw new OLAPException(dim + " " + level + " property column required.");
        }
        if (levels.containsKey(level.name)) {
            throw new OLAPException(dim + " " + level + " redefined.");
        }
        levels.put(level.name, level);
        if (level.rule != null && !this.rules.containsKey(level.rule)) {
            throw new OLAPException(dim + " " + level + " rule '" + level.rule + "' not found.");
        }
        Hashtable<String, PropertyDef> props = new Hashtable<String, PropertyDef>();
        if (level.properties != null) {
            for (int i = 0; i < level.properties.length; ++i) {
                PropertyDef prop = level.properties[i];
                if (prop.name == null) {
                    throw new OLAPException(dim + " " + level + " Property name required.");
                }
                if (prop.column == null) {
                    throw new OLAPException(dim + " " + level + " " + prop + " property column required.");
                }
                if (props.containsKey(prop.name)) {
                    throw new OLAPException(dim + " " + level + " " + prop + " redefined.");
                }
                props.put(prop.name, prop);
            }
        }
        if (level.orderMethod != null && !level.orderMethod.equalsIgnoreCase("asc") && !level.orderMethod.equalsIgnoreCase("desc")) {
            throw new OLAPException(dim + "" + level + " orderMethod must be 'asc' or 'desc'.");
        }
    }

    private void checkConnection(ConnectionDef cn) throws OLAPException {
        if (cn.connectionString == null) {
            throw new OLAPException(cn + " connectionString required.");
        }
    }

    private void checkTable(TableDef table) throws OLAPException {
        if (table.name == null) {
            throw new OLAPException("Table name required.");
        }
        if (table.sql == null) {
            throw new OLAPException(table + " property sql required.");
        }
        this.newTable(table.name, table);
    }

    private void checkParameter(ParameterDef p) throws OLAPException {
        if (p.name == null) {
            throw new OLAPException("Parameter name required.");
        }
        if (p.type == null) {
            throw new OLAPException(p.toString() + " property 'type' required.");
        }
        if (p.type.equals("Connection")) {
            this.newConnection(p.name, p);
        } else if (p.type.equalsIgnoreCase("Table")) {
            this.newTable(p.name, p);
        } else if (p.type.equals("ParentMemberRule")) {
            this.newRule(p.name, p);
        } else {
            throw new OLAPException(p.toString() + " unknown type '" + p.type + "'");
        }
    }

    private void newConnection(String name, Object x) throws OLAPException {
        this.newObject("Connection", this.conns, name, x);
    }

    private void newDimension(String name, Object x) throws OLAPException {
        this.newObject("Dimension", this.dims, name, x);
    }

    private void newCube(String name, Object x) throws OLAPException {
        this.newObject("Cube", this.cubes, name, x);
    }

    private void newTable(String name, Object x) throws OLAPException {
        this.newObject("Table", this.tables, name, x);
    }

    private void newRule(String name, Object x) throws OLAPException {
        this.newObject("ParentMemberRule", this.rules, name, x);
    }

    private void newObject(String type, Hashtable set, String name, Object x) throws OLAPException {
        if (set.containsKey(name)) {
            throw new OLAPException(type + " redefined in " + x.toString());
        }
        set.put(name, x);
    }
}

