/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.calc.BigDecimalCalc;
import com.kingdee.bos.olap.mdx.calc.DoubleCalc;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.StringCalc;
import com.kingdee.bos.olap.mdx.calc.VoidCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractCalc;
import java.math.BigDecimal;

public abstract class GenericCalc
extends AbstractCalc
implements StringCalc,
IntegerCalc,
DoubleCalc,
BigDecimalCalc,
VoidCalc {
    protected GenericCalc(Exp exp) {
        super(exp);
    }

    public IList evaluateList(Evaluator evaluator) throws OLAPException {
        return (IList)this.evaluate(evaluator);
    }

    @Override
    public String evaluateString(Evaluator evaluator) throws OLAPException {
        Object o = this.evaluate(evaluator);
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof Member) {
            return this.evaluateString(evaluator.push((Member)o));
        }
        throw new OLAPException("Can't convert " + this.exp.toMdx() + " to String.");
    }

    @Override
    public int evaluateInteger(Evaluator evaluator) throws OLAPException {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new OLAPException("Can't convert " + this.exp.toMdx() + " to Integer.");
    }

    @Override
    public double evaluateDouble(Evaluator evaluator) throws OLAPException {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        Number number = (Number)o;
        return number.doubleValue();
    }

    @Override
    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OLAPException {
        Object o = this.evaluate(evaluator);
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new BigDecimal(number.doubleValue());
        }
        throw new OLAPException("Can't convert " + this.exp.toMdx() + " to Number.");
    }

    @Override
    public void evaluateVoid(Evaluator evaluator) throws OLAPException {
        this.evaluate(evaluator);
    }

    public Member evaluateMember(Evaluator evaluator) throws OLAPException {
        return (Member)this.evaluate(evaluator);
    }

    public Level evaluateLevel(Evaluator evaluator) throws OLAPException {
        return (Level)this.evaluate(evaluator);
    }

    public Hierarchy evaluateHierarchy(Evaluator evaluator) throws OLAPException {
        return (Hierarchy)this.evaluate(evaluator);
    }

    public Dimension evaluateDimension(Evaluator evaluator) throws OLAPException {
        return (Dimension)this.evaluate(evaluator);
    }
}

