/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl.func;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.DimensionCalc;
import com.kingdee.bos.olap.mdx.calc.LevelCalc;
import com.kingdee.bos.olap.mdx.calc.Scope;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractMemberCalc;
import com.kingdee.bos.olap.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.LevelFirstMemberCalc;

public class DimensionFirstMemberCalc
extends AbstractMemberCalc {
    DimensionCalc dimensionCalc;

    public DimensionFirstMemberCalc(Exp exp, DimensionCalc dimensionCalc) {
        super(exp, new Calc[]{dimensionCalc});
        this.dimensionCalc = dimensionCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OLAPException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(null);
        Level level = dimension.getDefaultHierarchy().getLevels()[0];
        LevelCalc levelCalc = ConstantCalc.constantLevel(level);
        return new LevelFirstMemberCalc(null, levelCalc).optimize(scope, evaluator);
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OLAPException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
        Hierarchy hierarchy = dimension.getDefaultHierarchy();
        IMemberList list = evaluator.getSchemaReader().getHierarchyRootMembers(hierarchy);
        if (list.isEmpty()) {
            return hierarchy.getNullMember();
        }
        return (Member)list.getFirst();
    }
}

