/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl.func;

import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.LevelCalc;
import com.kingdee.bos.olap.mdx.calc.MemberCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractMemberCalc;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;

public class ParallelPeriodCalc
extends AbstractMemberCalc {
    MemberCalc memberCalc;
    IntegerCalc lagValueCalc;
    LevelCalc ancestorLevelCalc;

    public ParallelPeriodCalc(Exp call, MemberCalc memberCalc, IntegerCalc lagValueCalc, LevelCalc ancestorLevelCalc) {
        super(call, new Calc[]{memberCalc, lagValueCalc, ancestorLevelCalc});
        this.memberCalc = memberCalc;
        this.lagValueCalc = lagValueCalc;
        this.ancestorLevelCalc = ancestorLevelCalc;
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OLAPException {
        Level ancestorLevel;
        Member member = this.memberCalc.evaluateMember(evaluator);
        int lagValue = this.lagValueCalc.evaluateInteger(evaluator);
        if (this.ancestorLevelCalc != null) {
            ancestorLevel = this.ancestorLevelCalc.evaluateLevel(evaluator);
        } else {
            Member parent = member.getParentMember();
            if (parent == null) {
                return member.getHierarchy().getNullMember();
            }
            ancestorLevel = parent.getLevel();
        }
        return this.parallelPeriod(member, ancestorLevel, evaluator, lagValue);
    }

    private Member parallelPeriod(Member member, Level ancestorLevel, Evaluator evaluator, int lagValue) throws OLAPException {
        int distance = member.getLevel().getDepth() - ancestorLevel.getDepth();
        Member ancestor = FuncUtil2.ancestor(evaluator, member, distance, ancestorLevel);
        Member inLaw = evaluator.getSchemaReader().getLeadMember(ancestor, -lagValue);
        return FuncUtil2.cousin(evaluator.getSchemaReader(), member, inLaw);
    }
}

