/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.elementexp;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpBase;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.olap.mdx.type.MemberType;
import com.kingdee.bos.olap.mdx.type.Type;

public class MemberExpr
extends ExpBase
implements Exp {
    private final Member member;

    public MemberExpr(Member member) {
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    public String toString() {
        return this.member.getUniqueName();
    }

    @Override
    public Type getType() {
        return MemberType.forMember(this.member);
    }

    @Override
    public Object clone() {
        return new MemberExpr(this.member);
    }

    @Override
    public int getCategory() {
        return 6;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantMember(this.member);
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OLAPException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws OLAPException {
        return this.member;
    }

    public boolean equals(Object x) {
        if (x instanceof MemberExpr) {
            return this.member.equals(((MemberExpr)x).member);
        }
        return false;
    }
}

