/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.HierarchyCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractMemberCalc;

public class HierarchyCurrentMemberFunDef
extends FunDefBase {
    static final HierarchyCurrentMemberFunDef instance = new HierarchyCurrentMemberFunDef();

    private HierarchyCurrentMemberFunDef() {
        super("CurrentMember", "<Hierarchy>.CurrentMember", "Returns the current member along a hierarchy during an iteration.", "pmh");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) throws OLAPException {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            Member member = evaluator.getContext(hierarchy.getDimension());
            return member;
        }

        public boolean dependsOn(Dimension dimension) {
            return this.hierarchyCalc.getType().usesDimension(dimension);
        }
    }
}

