/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mem.impl.Aggregators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Aggregator
implements Serializable {
    public static final long serialVersionUID = 4576365898477547547L;
    public static final String SUM = "sum";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String AVG = "avg";
    public static final String COUNT = "count";
    public static final String FIRST = "first";
    public static final String LAST = "last";
    private static final HashMap aggregators = new HashMap();
    public final String name;

    public static void registerAggregator(Aggregator x) {
        aggregators.put(x.name, x);
    }

    public static Aggregator getAggregator(String name) throws OLAPException {
        Aggregator x = (Aggregator)aggregators.get(name);
        if (x == null) {
            throw new OLAPException("Aggregator '" + name + "' not found.");
        }
        return x;
    }

    public Aggregator(String _name) {
        this.name = _name;
    }

    public abstract Object appendValue(Object var1, Object var2) throws OLAPException;

    public abstract Object appendAggregator(Object var1, Object var2) throws OLAPException;

    public abstract Object getValue(Object var1) throws OLAPException;

    public abstract boolean valueIsCompounded();

    public ValueSerializable getSerialize() {
        return null;
    }

    static {
        Aggregators.class.toString();
    }

    public static interface ValueSerializable {
        public Object deserialize(int var1, DataInput var2) throws IOException, ClassNotFoundException;

        public void serialize(Object var1, int var2, DataOutput var3) throws IOException;
    }
}

