/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.MemoryTable;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.dbsource.TableManager;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.impl.BuildContext;
import com.kingdee.bos.olap.mem.impl.ChunkedCubeData;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.impl.DimensionBuildResult;
import com.kingdee.bos.olap.mem.impl.DimensionBuilder;
import com.kingdee.bos.olap.mem.impl.DimensionFetch;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.DimensionUsageFetch;
import com.kingdee.bos.olap.mem.impl.MeasureFetch;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import com.kingdee.bos.olap.mem.impl.PrivateDimensionFetch;
import com.kingdee.bos.olap.mem.impl.RecordAdd;
import com.kingdee.bos.olap.mem.impl.SchemaBuilder;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OLAPBuilder {
    private static Logger logger = CommonLogger.getLogger(OLAPBuilder.class);

    public static TableManager getTableManager(SchemaDef def, Map params) throws OLAPException, SQLException {
        return new TableManager(def, params);
    }

    public static SchemaImpl buildSchema(BuildContext buildContext, SchemaDef def, List notVisibleMeasures, boolean checkSchemaDef) throws OLAPException, SQLException {
        if (checkSchemaDef) {
            logger.debug((Object)"checking schema define...");
            def.check();
        }
        logger.debug((Object)"building schema object...");
        SchemaImpl schema = SchemaBuilder.buildSchema(def);
        logger.debug((Object)"schema building succeeded.");
        logger.debug((Object)"preparing connection & table Manager.");
        if (def.dimensions != null) {
            for (int i = 0; i < def.dimensions.length; ++i) {
                DimensionBuilder.buildSharedDimension(buildContext, schema.dims[i], def.dimensions[i]);
            }
        }
        if (notVisibleMeasures != null && notVisibleMeasures.size() > 0) {
            MemberImpl[] measures = schema.cubes[0].measures;
            for (int i = 0; i < measures.length; ++i) {
                if (!notVisibleMeasures.contains(measures[i].getName())) continue;
                measures[i].setVisible(false);
            }
        }
        return schema;
    }

    public static OLAPDatabase buildDatabase(BuildContext buildContext, SchemaImpl schema, SchemaDef def) throws OLAPException, SQLException {
        OLAPDatabase dataSet = new OLAPDatabase(schema);
        for (int i = 0; i < def.cubes.length; ++i) {
            CubeData cubeData = OLAPBuilder.buildCubeData(buildContext, schema, schema.cubes[i], def.cubes[i]);
            dataSet.setData(def.cubes[i].name, cubeData);
        }
        return dataSet;
    }

    private static CubeData getCubeData(CubeImpl cube) throws OLAPException {
        return new ChunkedCubeData(cube);
    }

    private static CubeData buildCubeData(BuildContext buildContext, SchemaImpl schema, CubeImpl cube, CubeDef cubeDef) throws OLAPException, SQLException {
        int i;
        long time0;
        logger.debug((Object)("building cube '" + cubeDef.name + "'..."));
        CubeData data = OLAPBuilder.getCubeData(cube);
        Table table = buildContext.getTableManager().getTable(cubeDef.table);
        int dimCount = cube.dims.length;
        DimensionFetch[] cdfs = new DimensionFetch[dimCount];
        ArrayList<DimensionFetch> privdfs = new ArrayList<DimensionFetch>();
        boolean hasPrivDim = false;
        for (int i2 = 0; i2 < dimCount; ++i2) {
            CubeDimension cd = cubeDef.dimensions[i2];
            if (cd instanceof DimensionUsageDef) {
                DimensionImpl dim2 = (DimensionImpl)cube.getDimension(cube.dims[i2].getName());
                cube.dims[i2].memberCount = dim2.memberCount;
                cube.dims[i2].mapOrderToMember = dim2.mapOrderToMember;
                DimensionBuildResult dbr = buildContext.getDimensionResult(cd.name);
                cdfs[i2] = new DimensionUsageFetch(dbr, cube.dims[i2], (DimensionUsageDef)cd);
                continue;
            }
            cdfs[i2] = new PrivateDimensionFetch(cube.dims[i2], (CubeDimensionDef)cd);
            privdfs.add(cdfs[i2]);
            hasPrivDim = true;
            table = new MemoryTable(table);
        }
        if (hasPrivDim) {
            int size = privdfs.size();
            PrivateDimensionFetch[] dfs = new PrivateDimensionFetch[size];
            privdfs.toArray(dfs);
            while (table.next()) {
                for (int i3 = 0; i3 < size; ++i3) {
                    dfs[i3].preCalculate(table);
                }
            }
            for (int i4 = 0; i4 < size; ++i4) {
                dfs[i4].preFinish();
                dfs[i4].reset();
            }
            table = new MemoryTable(table);
        }
        int measureCount = cube.measures.length;
        MeasureFetch[] mfs = new MeasureFetch[measureCount];
        for (int i5 = 0; i5 < measureCount; ++i5) {
            mfs[i5] = new MeasureFetch(cube.measures[i5], cubeDef.measures[i5]);
        }
        RecordAdd ra = new RecordAdd(cube, data);
        logger.debug((Object)"fetching cube data...");
        int recordCount = 0;
        int errorCount = 0;
        long time = time0 = System.currentTimeMillis();
        block5: while (table.next()) {
            ++recordCount;
            for (i = 0; i < dimCount; ++i) {
                MemberImpl[] members = cdfs[i].fetch(table);
                for (int j = 0; j < members.length; ++j) {
                    if (members[j] != null) continue;
                    ++errorCount;
                    continue block5;
                }
                ra.setMembers(i, members);
            }
            Object[] values = new Object[measureCount];
            for (int i6 = 0; i6 < measureCount; ++i6) {
                values[i6] = mfs[i6].fetch(table);
            }
            ra.addRecord(values);
            long time1 = System.currentTimeMillis();
            if (time1 - time0 < 8000L) continue;
            time0 = time1;
            logger.debug((Object)(" " + recordCount + " records fetched."));
        }
        data.finishAddRecord();
        time = System.currentTimeMillis() - time;
        logger.debug((Object)("fetch collpase " + time + "ms."));
        logger.debug((Object)(" " + recordCount + "records fetched."));
        if (errorCount > 0) {
            logger.debug((Object)("Found " + errorCount + " error records"));
        }
        table.close();
        buildContext.getTableManager().releaseTable(cubeDef.table);
        for (i = 0; i < dimCount; ++i) {
            cdfs[i].finish();
        }
        time = System.currentTimeMillis();
        data.buildData();
        data.finishBuildData();
        time = System.currentTimeMillis() - time;
        logger.debug((Object)("build collpase " + time + "ms."));
        return data;
    }
}

