/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.CalculatedMemberDef;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.MemberProperty;
import com.kingdee.bos.olap.mdx.ParserHelp;
import com.kingdee.bos.olap.mem.impl.CalculatedMemberImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.HierarchyImpl;
import com.kingdee.bos.olap.mem.impl.LevelImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import com.kingdee.bos.olap.mem.impl.PropertyImpl;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;

public class SchemaBuilder {
    public static SchemaImpl buildSchema(SchemaDef def) throws OLAPException {
        int i;
        SchemaImpl schema = new SchemaImpl();
        schema.setProperty("name", def.name);
        schema.setProperty("caption", def.caption);
        schema.setProperty("description", def.description);
        schema.dims = null;
        schema.dims = def.dimensions == null ? new DimensionImpl[0] : new DimensionImpl[def.dimensions.length];
        for (i = 0; i < schema.dims.length; ++i) {
            schema.dims[i] = SchemaBuilder.buildSharedDimension(schema, def.dimensions[i]);
        }
        schema.cubes = new CubeImpl[def.cubes.length];
        for (i = 0; i < schema.cubes.length; ++i) {
            schema.cubes[i] = SchemaBuilder.buildCube(schema, def.cubes[i]);
        }
        return schema;
    }

    private static DimensionImpl buildSharedDimension(SchemaImpl schema, SharedDimensionDef x) throws OLAPException {
        DimensionImpl dim = new DimensionImpl();
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("table", x.table);
        dim.setProperty("type", x.type);
        dim.setProperty("primaryKey", x.primaryKey);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new HierarchyImpl[x.hierarchies.length];
        for (int i = 0; i < dim.hies.length; ++i) {
            dim.hies[i] = SchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
        }
        dim.setProperty("Permission", x.permission);
        return dim;
    }

    private static HierarchyImpl buildHierarchy(int ordinal, DimensionImpl dim, HierarchyDef x) throws OLAPException {
        int i;
        HierarchyImpl hie = new HierarchyImpl(dim, x.name, x.caption);
        hie.ordinal = ordinal;
        hie.setProperty("description", x.description);
        hie.setProperty("hasAll", x.hasAll);
        hie.setProperty("allMemberName", x.allMemberName);
        hie.setProperty("allMemberCaption", x.allMemberCaption);
        hie.setProperty("virtualAllMemberCaption", x.v$AllMemberCaption);
        hie.levels = new LevelImpl[x.levels.length];
        for (i = 0; i < hie.levels.length; ++i) {
            hie.levels[i] = SchemaBuilder.buildLevel(hie, x.levels[i]);
        }
        for (i = 0; i < hie.levels.length; ++i) {
            if (i > 0) {
                hie.levels[i].parent = hie.levels[i - 1];
            }
            if (i < hie.levels.length - 1) {
                hie.levels[i].child = hie.levels[i + 1];
            }
            hie.levels[i].depth = x.hasAll ? (byte)(i + 1) : (byte)i;
        }
        return hie;
    }

    private static LevelImpl buildLevel(HierarchyImpl hie, LevelDef x) throws OLAPException {
        LevelImpl level = new LevelImpl();
        level.hie = hie;
        level.setProperty("name", x.name);
        level.setProperty("caption", x.caption);
        level.setProperty("description", x.description);
        level.setProperty("type", x.type);
        level.levelType = x.type == null ? (byte)0 : Util.getLevelType(x.type);
        level.setProperty("column", x.column);
        level.setProperty("orderBy", x.orderBy);
        level.setProperty("parentColumn", x.parentColumn);
        level.setProperty("childColumn", x.childColumn);
        level.setProperty("dataType", x.dataType);
        level.setProperty("closureDataType", x.closureDataType);
        level.setProperty("rule", x.rule);
        level.props = new PropertyImpl[x.properties.length];
        for (int i = 0; i < level.props.length; ++i) {
            level.props[i] = SchemaBuilder.buildProperty(x.properties[i]);
        }
        if (x.parentColumn != null) {
            hie.dim.isParentChildren = true;
        }
        return level;
    }

    private static PropertyImpl buildProperty(PropertyDef x) {
        PropertyImpl p = new PropertyImpl();
        p.setProperty("name", x.name);
        p.setProperty("caption", x.caption);
        p.setProperty("description", x.description);
        p.setProperty("column", x.column);
        p.setProperty("dataType", x.dataType);
        return p;
    }

    private static CubeImpl buildCube(SchemaImpl schema, CubeDef x) throws OLAPException {
        int i;
        CubeImpl cube = new CubeImpl();
        cube.setProperty("name", x.name);
        cube.setProperty("caption", x.caption);
        cube.setProperty("description", x.description);
        cube.setProperty("table", x.table);
        cube.initMeasures(x);
        cube.dims = new DimensionImpl[x.dimensions.length];
        for (i = 0; i < cube.dims.length; ++i) {
            cube.dims[i] = x.dimensions[i] instanceof DimensionUsageDef ? SchemaBuilder.buildDimensionUsage((DimensionImpl)schema.getDimension(x.dimensions[i].name), (DimensionUsageDef)x.dimensions[i]) : SchemaBuilder.buildCubeDimension(schema, (CubeDimensionDef)x.dimensions[i]);
        }
        cube.measures = new MemberImpl[x.measures.length];
        for (i = 0; i < cube.measures.length; ++i) {
            cube.measures[i] = SchemaBuilder.buildMeasure(cube, x.measures[i]);
        }
        cube.measureHierarchy.members = cube.measures;
        if (x.calculatedMembers == null) {
            cube.calculatedMembers = new CalculatedMemberImpl[0];
        } else {
            cube.calculatedMembers = new CalculatedMemberImpl[x.calculatedMembers.length];
            for (i = 0; i < x.calculatedMembers.length; ++i) {
                cube.calculatedMembers[i] = SchemaBuilder.buildCalculatedMember(cube, x.calculatedMembers[i]);
            }
        }
        return cube;
    }

    private static CalculatedMemberImpl buildCalculatedMember(CubeImpl cube, CalculatedMemberDef def) throws OLAPException {
        String[] uniqueName = new String[]{def.dimension, def.name};
        Exp exp = ParserHelp.parseExpression(def.formula);
        ArrayList<MemberProperty> jlist = new ArrayList<MemberProperty>();
        if (def.formatString != null) {
            jlist.add(new MemberProperty("formatString", Literal.createString(def.formatString)));
        }
        if (def.color != null) {
            jlist.add(new MemberProperty("color", Literal.createString(def.color)));
        }
        if (def.bgColor != null) {
            jlist.add(new MemberProperty("bgColor", Literal.createString(def.bgColor)));
        }
        if (def.trend != null) {
            jlist.add(new MemberProperty("trend", Literal.createString(def.trend)));
        }
        if (def.status != null) {
            jlist.add(new MemberProperty("status", Literal.createString(def.status)));
        }
        if (def.solveOrder != null) {
            jlist.add(new MemberProperty("SOLVE_ORDER", Literal.create(new Integer(def.solveOrder))));
        }
        if (def.caption != null) {
            jlist.add(new MemberProperty("caption", Literal.createString(def.caption)));
        }
        if (!def.visible) {
            jlist.add(new MemberProperty("visible", Literal.createString("false")));
        }
        if (def.properties != null) {
            for (int i = 0; i < def.properties.length; ++i) {
                jlist.add(new MemberProperty(def.properties[i].name, Literal.createString(def.properties[i].value)));
            }
        }
        MemberProperty[] properties = new MemberProperty[jlist.size()];
        jlist.toArray(properties);
        Formula formula = new Formula(uniqueName, exp, properties, null);
        Dimension dim = cube.getDimension(def.dimension);
        CalculatedMemberImpl m = (CalculatedMemberImpl)dim.getDefaultHierarchy().createMember(def.name, def.caption, formula, true);
        formula.setMember(m);
        return m;
    }

    private static DimensionImpl buildDimensionUsage(DimensionImpl source, DimensionUsageDef x) throws OLAPException {
        source.setProperty("foreignKey", x.foreignKey);
        return source;
    }

    private static DimensionImpl buildCubeDimension(SchemaImpl schema, CubeDimensionDef x) throws OLAPException {
        DimensionImpl dim = new DimensionImpl();
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("type", x.type);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new HierarchyImpl[x.hierarchies.length];
        for (int i = 0; i < dim.hies.length; ++i) {
            dim.hies[i] = SchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
        }
        return dim;
    }

    private static MemberImpl buildMeasure(CubeImpl cube, MeasureDef x) {
        MemberImpl measure = new MemberImpl();
        measure.memberType = (byte)2;
        measure.level = cube.measureLevel;
        measure.setProperty("name", x.name);
        measure.setProperty("caption", x.caption);
        measure.setProperty("description", x.description);
        measure.setProperty("column", x.column);
        measure.setProperty("aggregator", x.aggregator);
        measure.setProperty("formatString", x.formatString);
        measure.setProperty("color", x.color);
        measure.setProperty("bgColor", x.bgColor);
        measure.setProperty("trend", x.trend);
        measure.setProperty("status", x.status);
        measure.setProperty("visible", x.visible);
        if (x.properties != null) {
            for (int i = 0; i < x.properties.length; ++i) {
                measure.setProperty(x.properties[i].name, x.properties[i].value);
            }
        }
        return measure;
    }
}

