/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.storage;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mem.Aggregator;
import com.kingdee.bos.olap.mem.Chunk;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.Point;
import com.kingdee.bos.olap.mem.impl.ChunkImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.storage.Bucket;
import com.kingdee.bos.olap.mem.storage.BucketStorageManager;
import com.kingdee.bos.olap.mem.storage.PropertySet;
import com.kingdee.bos.olap.util.ByteArrayInputStream;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.bos.olap.util.InOutSqlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ChunkStorageManager {
    private static Logger logger = CommonLogger.getLogger(ChunkStorageManager.class);
    private BucketStorageManager bsm;
    private int pointCount = 0;
    private boolean alwaysUseMem = true;
    private boolean diskUsed = false;
    private int valve = 10000;
    private HashMap memChunkCache = new HashMap();
    HashMap chunkIndex = new HashMap();
    private PropertySet ps;
    private CubeData cubeData;
    private Member[] measures;
    private Aggregator[] aggs;
    Chunk cache = null;

    public ChunkStorageManager(PropertySet ps, CubeData cubeData) throws IOException {
        this.cubeData = cubeData;
        this.ps = ps;
        Boolean b = (Boolean)ps.getProperty("AlwaysUseMem");
        this.alwaysUseMem = b;
        Integer i = (Integer)ps.getProperty("PointValve");
        this.valve = i;
    }

    public void save(Chunk chunk) throws IOException, OLAPException {
        this.save(chunk, true);
    }

    public void save(Chunk chunk, boolean override) throws IOException, OLAPException {
        int i;
        int i2;
        if (this.measures == null) {
            CubeImpl cube = (CubeImpl)this.cubeData.cube;
            this.measures = cube.getMeasures();
            this.aggs = cube.getAggregators();
        }
        if (!this.diskUsed) {
            this.saveToMem(chunk, override);
            return;
        }
        Chunk.ChunkId id = chunk.getId();
        if (this.chunkIndex.get(id) != null) {
            Chunk chunk2 = this.removeChunk(id);
            this.mergeChunk(chunk, chunk2, override);
            this.pointCount += chunk.size() - chunk2.size();
        } else {
            this.pointCount += chunk.size();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream(1024);
        int pointCount = chunk.size();
        baos.writeInt(pointCount);
        int[] key = new int[pointCount];
        byte[][] valuebytes = new byte[pointCount][];
        int index = 0;
        Iterator entryIter = chunk.entryIterator();
        while (entryIter.hasNext()) {
            Chunk.Entry entry = (Chunk.Entry)entryIter.next();
            key[index] = entry.point.getKey();
            Object[] values = entry.values;
            baos2.reset();
            for (int i3 = 0; i3 < this.measures.length; ++i3) {
                boolean valueIsCompounded = this.aggs[i3] != null && this.aggs[i3].valueIsCompounded();
                InOutSqlUtil.writeObject(values[i3], this.measures[i3].getDataType(), valueIsCompounded, this.aggs[i3] == null ? null : this.aggs[i3].getSerialize(), baos2);
            }
            if (values.length > this.measures.length) {
                baos2.writeBoolean(true);
                Object[] propValues = new Object[values.length - this.measures.length];
                System.arraycopy(values, this.measures.length, propValues, 0, propValues.length);
                byte[] bs = InOutSqlUtil.serialize(propValues);
                baos2.writeInt(bs.length);
                baos2.write(bs);
            } else {
                baos2.writeBoolean(false);
            }
            valuebytes[index++] = baos2.toByteArray();
        }
        int pos = 4 + 4 * pointCount * 3;
        for (i2 = 0; i2 < pointCount; ++i2) {
            baos.writeInt(key[i2]);
            baos.writeInt(pos);
            baos.writeInt(valuebytes[i2].length);
            pos += valuebytes[i2].length;
        }
        for (i2 = 0; i2 < pointCount; ++i2) {
            baos.write(valuebytes[i2]);
        }
        byte[] bs = baos.toByteArray();
        int length = bs.length + 4;
        int bucketLength = this.bsm.canUseBucketSize();
        int count = length / bucketLength;
        int residue = length % bucketLength;
        if (residue > 0) {
            ++count;
        }
        Bucket[] buckets = this.bsm.allocBucket(count);
        int[] bucketIds = new int[count];
        for (i = 0; i < count; ++i) {
            bucketIds[i] = buckets[i].id;
        }
        this.chunkIndex.put(chunk.getId(), bucketIds);
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                buckets[i].writeInt(length);
                if (count == 1 && residue > 0) {
                    buckets[i].writeBytes(bs, 0, residue - 4);
                } else {
                    buckets[i].writeBytes(bs, 0, bucketLength - 4);
                }
            } else if (i == count - 1 && residue > 0) {
                buckets[i].writeBytes(bs, i * bucketLength - 4, residue);
            } else {
                buckets[i].writeBytes(bs, i * bucketLength - 4, bucketLength);
            }
            buckets[i].flush();
        }
    }

    public void saveToMem(Chunk chunk, boolean override) throws IOException, OLAPException {
        Chunk.ChunkId id = chunk.getId();
        Chunk chunk2 = (Chunk)this.memChunkCache.get(id);
        if (chunk2 != null) {
            this.mergeChunk(chunk, chunk2, override);
            this.pointCount += chunk.size() - chunk2.size();
        } else {
            this.pointCount += chunk.size();
        }
        this.memChunkCache.put(id, chunk);
        if (!this.alwaysUseMem && this.pointCount > this.valve) {
            this.diskUsed = true;
            logger.debug((Object)"start using disk cache");
            this.initBSM();
            Iterator iter = this.memChunkCache.values().iterator();
            while (iter.hasNext()) {
                Chunk ck = (Chunk)iter.next();
                this.save(ck, override);
                iter.remove();
            }
            this.memChunkCache = null;
        }
    }

    private void mergeChunk(Chunk newChunk, Chunk oldChunk, boolean override) throws IOException, OLAPException {
        Iterator entryIter2 = oldChunk.entryIterator();
        while (entryIter2.hasNext()) {
            Chunk.Entry entry2 = (Chunk.Entry)entryIter2.next();
            Chunk.Entry entry1 = newChunk.getEntry(entry2.point.getKey());
            if (entry1 == null) {
                newChunk.add(entry2.point, entry2.values);
                continue;
            }
            if (override) continue;
            Object[] values = newChunk.getCubeData().appendAggregator(entry2.values, entry1.values);
            entry1.values = values;
        }
    }

    private void initBSM() throws IOException {
        this.bsm = new BucketStorageManager(this.ps);
    }

    public Chunk getChunk(Chunk.ChunkId id) throws IOException, OLAPException {
        if (this.cache != null && this.cache.getId() == id) {
            return this.cache;
        }
        this.cache = this.getChunk(id, false);
        return this.cache;
    }

    public Chunk removeChunk(Chunk.ChunkId id) throws IOException, OLAPException {
        return this.getChunk(id, true);
    }

    private Chunk getChunk(Chunk.ChunkId id, boolean deleteBucket) throws IOException, OLAPException {
        int i;
        if (!this.diskUsed) {
            return (Chunk)this.memChunkCache.get(id);
        }
        int[] bucketIds = null;
        bucketIds = (int[])this.chunkIndex.get(id);
        if (bucketIds == null) {
            return null;
        }
        ChunkImpl chunk = new ChunkImpl(this, id, this.cubeData);
        CubeImpl cube = (CubeImpl)this.cubeData.cube;
        this.measures = cube.getMeasures();
        this.aggs = cube.getAggregators();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.bsm.canUseBucketSize() * bucketIds.length);
        for (int i2 = 0; i2 < bucketIds.length; ++i2) {
            Bucket bucket = this.bsm.getBucket(bucketIds[i2]);
            bucket.readFully();
            baos.write(bucket.toByteArray());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        bais.readInt();
        int pointCount = bais.readInt();
        int[] keys = new int[pointCount];
        for (i = 0; i < pointCount; ++i) {
            keys[i] = bais.readInt();
            bais.skipBytes(8);
        }
        for (i = 0; i < pointCount; ++i) {
            Object[] values = new Object[this.measures.length];
            for (int j = 0; j < this.measures.length; ++j) {
                boolean valueIsCompounded = this.aggs[j] != null && this.aggs[j].valueIsCompounded();
                values[j] = InOutSqlUtil.readObject(this.measures[j].getDataType(), valueIsCompounded, this.aggs[j] == null ? null : this.aggs[j].getSerialize(), bais);
            }
            if (bais.readBoolean()) {
                int l = bais.readInt();
                byte[] bs = new byte[l];
                bais.readFully(bs);
                Object[] propValues = null;
                try {
                    propValues = (Object[])InOutSqlUtil.deserialize(bs);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage());
                }
                Object[] vs = new Object[values.length + propValues.length];
                System.arraycopy(values, 0, vs, 0, values.length);
                System.arraycopy(propValues, 0, vs, values.length, propValues.length);
                values = vs;
            }
            ((Chunk)chunk).add(new Point(cube, keys[i]), values);
        }
        if (deleteBucket) {
            this.bsm.deleteBucket(bucketIds);
            this.chunkIndex.remove(id);
        }
        return chunk;
    }

    public void close() {
        if (this.bsm != null) {
            this.bsm.close();
        }
    }

    public void release() {
        if (this.bsm != null) {
            this.bsm.release();
        }
    }

    public static ChunkStorageManager getChunkStorageManager(CubeData cubeData) throws IOException {
        return new ChunkStorageManager(PropertySet.getSystemPropertySet(), cubeData);
    }

    public int getChunkCount() {
        if (!this.diskUsed) {
            return this.memChunkCache.size();
        }
        return this.chunkIndex.size();
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public Iterator chunkIterator() {
        if (!this.diskUsed) {
            return this.memChunkCache.values().iterator();
        }
        return new DiskChunkIterator();
    }

    private class DiskChunkIterator
    implements Iterator {
        Iterator keyIter;

        DiskChunkIterator() {
            this.keyIter = ChunkStorageManager.this.chunkIndex.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        public Object next() {
            Chunk.ChunkId id = (Chunk.ChunkId)this.keyIter.next();
            try {
                return ChunkStorageManager.this.getChunk(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

