/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.base.CellImpl;
import com.kingdee.bos.olap.base.CellKey;
import com.kingdee.bos.olap.base.CellValues;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.MdxAxis;
import com.kingdee.bos.olap.mdx.MdxMember;
import com.kingdee.bos.olap.mdx.MdxPosition;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.Iterator;

public class CommonResultImpl
implements MdxResult {
    private static final long serialVersionUID = 5991493095599574985L;
    private transient MdxQuery query;
    private MdxAxis slicerAxis;
    private MdxAxis rowAxis;
    private MdxAxis columnAxis;
    private MdxAxis[] axes;
    private CellValues cellValues;

    protected CommonResultImpl(MdxQuery query, IList slicerList, IList rowList, IList columnList, boolean x, CellValues cellValues) {
        this.query = query;
        this.slicerAxis = this.makeAxis("", slicerList);
        this.rowAxis = this.makeAxis("rows", rowList);
        this.columnAxis = this.makeAxis("columns", columnList);
        this.cellValues = cellValues;
        this.axes = !x ? new MdxAxis[]{this.rowAxis, this.columnAxis} : new MdxAxis[]{this.columnAxis, this.rowAxis};
    }

    private MdxAxis makeAxis(String name, IList list) {
        if (list == null) {
            return new MdxAxis(name, new MdxPosition[0]);
        }
        ArrayList<MdxPosition> jlist = new ArrayList<MdxPosition>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Member[] ms = Util.toMemberArray(iter.next());
            jlist.add(new MdxPosition(ms));
        }
        MdxPosition[] positions = new MdxPosition[jlist.size()];
        jlist.toArray(positions);
        return new MdxAxis(name, positions);
    }

    @Override
    public void close() {
    }

    @Override
    public MdxAxis[] getAxes() {
        return this.axes;
    }

    @Override
    public Cell getCell(int[] pos) {
        int[] pos2 = (int[])pos.clone();
        Object value = this.cellValues.get(new CellKey(pos2));
        if (value == null) {
            return new CellImpl(this.getMdxMembers(pos));
        }
        return (Cell)value;
    }

    @Override
    public MdxQuery getQuery() {
        return this.query;
    }

    @Override
    public MdxAxis getSlicerAxis() {
        return this.slicerAxis;
    }

    @Override
    public MdxResult.ResultOverflowInfo getOverflowInfo() {
        return null;
    }

    public MdxMember[] getMdxMembers(int[] pos) {
        ArrayList<MdxMember> list = new ArrayList<MdxMember>();
        for (int i = -1; i < this.axes.length; ++i) {
            MdxAxis axis = this.slicerAxis;
            int index = 0;
            if (i >= 0) {
                axis = this.axes[i];
                index = pos[i];
            }
            MdxPosition position = axis.positions[index];
            MdxMember[] mdxMembers = position.getMdxMembers();
            for (int j = 0; j < mdxMembers.length; ++j) {
                list.add(mdxMembers[j]);
            }
        }
        MdxMember[] ms = new MdxMember[list.size()];
        list.toArray(ms);
        return ms;
    }
}

