/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import com.kingdee.bos.olap.util.EnumeratedValues;

public abstract class RelAggregator
extends EnumeratedValues.BasicValue {
    public static final RelAggregator Sum = new RelAggregator("sum", 0, false){

        @Override
        public Object aggregate(Evaluator evaluator, IList members, Calc calc) throws OLAPException {
            return FuncUtil2.sum(evaluator, members, calc);
        }
    };
    public static final RelAggregator Count = new RelAggregator("count", 1, false){

        @Override
        public RelAggregator getRollup() {
            return Sum;
        }

        @Override
        public Object aggregate(Evaluator evaluator, IList members, Calc calc) throws OLAPException {
            return FuncUtil2.count(evaluator, members, false);
        }
    };
    public static final RelAggregator Min = new RelAggregator("min", 2, false){

        @Override
        public Object aggregate(Evaluator evaluator, IList members, Calc calc) throws OLAPException {
            return FuncUtil2.min(evaluator, members, calc);
        }
    };
    public static final RelAggregator Max = new RelAggregator("max", 3, false){

        @Override
        public Object aggregate(Evaluator evaluator, IList members, Calc calc) throws OLAPException {
            return FuncUtil2.max(evaluator, members, calc);
        }
    };
    public static final RelAggregator Avg = new RelAggregator("avg", 4, false){

        @Override
        public RelAggregator getRollup() {
            return null;
        }

        @Override
        public Object aggregate(Evaluator evaluator, IList members, Calc calc) throws OLAPException {
            return FuncUtil2.avg(evaluator, members, calc);
        }
    };
    public static final EnumeratedValues enumeration = new EnumeratedValues(new RelAggregator[]{Sum, Count, Min, Max, Avg});
    private final boolean distinct;

    public RelAggregator(String name, int ordinal, boolean distinct) {
        super(name, ordinal, null);
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getExpression(String operand) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.name_);
        buf.append('(');
        if (this.distinct) {
            buf.append("distinct ");
        }
        buf.append(operand);
        buf.append(')');
        return buf.toString();
    }

    public RelAggregator getRollup() {
        return this;
    }

    public abstract Object aggregate(Evaluator var1, IList var2, Calc var3) throws OLAPException;
}

