/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.InnerMemberFactory;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Schema;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.mdx.CacheType;
import com.kingdee.bos.olap.mdx.DelegatingExpResolver;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.MemberExpr;
import com.kingdee.bos.olap.mdx.type.HierarchyType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.MemberReaderImpl;
import com.kingdee.bos.olap.rel.PCMemberReaderImpl;
import com.kingdee.bos.olap.rel.RelCalculatedMemberImpl;
import com.kingdee.bos.olap.rel.RelDimensionImpl;
import com.kingdee.bos.olap.rel.RelInnerMemberFactoryImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelSlicerCompoundMember;
import com.kingdee.bos.olap.rel.SmartMemberReader;
import com.kingdee.bos.olap.util.Util;
import java.util.HashMap;
import java.util.Map;

public class RelHierarchyImpl
extends OLAPElementBase
implements Hierarchy {
    int ordinal;
    RelDimensionImpl dim;
    RelLevelImpl[] levels;
    int depth;
    MemberReader memberReader;
    String subName;
    String subCaption;
    String uniqueName;
    HierarchyDef def;
    private Member defaultMember;
    private RelMemberImpl nullMember;
    private transient HashMap innerMembers = null;
    private transient RelLevelImpl innerLevel;
    private transient String allMemberName;
    private transient String allMemberCaption;
    private Exp allMemberAggregateExp;

    public RelHierarchyImpl(RelDimensionImpl dim, String subName, String subCaption) {
        this.dim = dim;
        this.subName = subName;
        this.subCaption = subCaption;
        this.name = dim.getName();
        if (this.subName != null) {
            this.name = this.name + "." + subName;
            this.uniqueName = Util.makeFqName(this.name);
        } else {
            this.uniqueName = dim.getUniqueName();
        }
        this.caption = dim.getCaption();
        if (this.subCaption != null) {
            this.caption = this.caption + "." + subCaption;
        }
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public Dimension getDimension() {
        return this.dim;
    }

    @Override
    public Level[] getLevels() {
        return this.levels;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean hasAll() {
        return (Boolean)this.getProperty("hasAll", Boolean.TRUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Member getDefaultMember() {
        if (this.defaultMember != null) return this.defaultMember;
        if (this.hasAll() || this.getDimension().isMeasureDimension()) {
            IMemberList ms = this.getMembers();
            if (ms == null || ms.size() <= 0) return null;
            this.defaultMember = (Member)ms.getFirst();
            return this.defaultMember;
        } else {
            this.defaultMember = this.getInnerAllMember();
        }
        return this.defaultMember;
    }

    @Override
    public IMemberList getMembers() {
        try {
            return this.getMemberReader().getRootMembers();
        }
        catch (OLAPException e) {
            return IMemberList.EMPTY;
        }
    }

    public Type getExpType() {
        return new HierarchyType(this);
    }

    public int getCategory() {
        return 3;
    }

    @Override
    public Member getNullMember() {
        if (this.nullMember == null) {
            this.nullMember = new RelMemberImpl(null);
            this.nullMember.memberType = (byte)16;
            this.nullMember.level = this.levels[0];
            this.nullMember.setName("#NULL");
        }
        return this.nullMember;
    }

    private Map getInnerMembers() {
        if (this.innerMembers == null) {
            this.innerMembers = new HashMap(2, 1.0f);
        }
        return this.innerMembers;
    }

    public RelLevelImpl getInnerLevel() {
        if (this.innerLevel == null) {
            this.innerLevel = RelInnerMemberFactoryImpl.createInnerLevel(this);
        }
        return this.innerLevel;
    }

    public Level lookupLevel(String name) {
        if (name == null) {
            return null;
        }
        if (this.innerLevel != null && this.innerLevel.getName().equalsIgnoreCase(name)) {
            return this.innerLevel;
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (!name.equalsIgnoreCase(this.levels[i].getName())) continue;
            return this.levels[i];
        }
        RelLevelImpl level = this.levels[this.levels.length - 1];
        while ((level = level.child) != null) {
            if (!name.equalsIgnoreCase(level.getName())) continue;
            return level;
        }
        return null;
    }

    @Override
    public Member getInnerAllMember() {
        return this.lookupInnerMember("V$All");
    }

    public Member lookupInnerMember(String name) {
        Map map = this.getInnerMembers();
        Object member = map.get(name.toUpperCase());
        if (member == null) {
            member = RelInnerMemberFactoryImpl.createInnerMember(this, name);
            map.put(name.toUpperCase(), member);
        }
        return (Member)member;
    }

    public OLAPElement lookupMember(SchemaReader schemaReader, String name) throws OLAPException {
        if (InnerMemberFactory.exists(name)) {
            return this.lookupInnerMember(name);
        }
        return SchemaLookup.lookupHierarchyRootMember(schemaReader, this, name);
    }

    public Member lookupLeafMember(SchemaReader schemaReader, String name) throws OLAPException {
        return SchemaLookup.lookupHierarchyLeafMember(schemaReader, this, name);
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        Level r = this.lookupLevel(name);
        if (r != null) {
            return r;
        }
        return this.lookupMember(schemaReader, name);
    }

    @Override
    public Object[] getChildren() {
        IMemberList list = this.getMembers();
        return list.toArray(new Member[0]);
    }

    @Override
    public String getAllMemberName() {
        if (this.allMemberName == null) {
            this.allMemberName = "All " + this.getName();
        }
        return this.allMemberName;
    }

    @Override
    public String getAllMemberCaption() {
        if (this.allMemberCaption == null) {
            this.allMemberCaption = OLAPEngine.getResource(this.dim.schema.conn.getLocale(), "allMemberCaptionPrefix") + this.getCaption();
        }
        return this.allMemberCaption;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this;
    }

    @Override
    public Member createSlicerCompoundMember(int index, Member[] members) {
        return new RelSlicerCompoundMember(index, this, members);
    }

    @Override
    public Member createMember(String name, String caption, Formula formula, boolean calculatedInSchema) {
        return this.createMember(null, this.levels[0], name, caption, formula, null, calculatedInSchema);
    }

    @Override
    public Member createMember(Member parent, Level level, String name, String caption, Formula formula, CacheType cacheType, boolean calculatedInSchema) {
        return new RelCalculatedMemberImpl(parent, level, name, caption, formula, cacheType, calculatedInSchema);
    }

    public synchronized MemberReader getMemberReader() throws OLAPException {
        if (this.memberReader == null) {
            this.memberReader = this.def.levels[0].parentColumn != null ? new PCMemberReaderImpl(this.dim.schema, this) : new SmartMemberReader(new MemberReaderImpl(this.dim.schema, this));
            this.memberReader.init();
        }
        return this.memberReader;
    }

    public Schema getSchema() {
        return this.dim.schema;
    }

    public SchemaReader getSchemaReader() {
        return this.dim.schema.conn.schemaReader;
    }

    public Exp getAllMemberAggregateExp() throws OLAPException {
        if (!this.hasAll() || !this.isAggregate()) {
            return null;
        }
        if (this.allMemberAggregateExp == null) {
            DelegatingExpResolver expResolver = new DelegatingExpResolver();
            Exp children = new FunCall("Children", new Exp[]{new MemberExpr(this.getDefaultMember())}, Syntax.Property);
            children = children.resolve(expResolver);
            Exp aggregate = new FunCall("Aggregate", new Exp[]{children}, Syntax.Function);
            aggregate = aggregate.resolve(expResolver);
            this.allMemberAggregateExp = aggregate;
        }
        return this.allMemberAggregateExp;
    }

    @Override
    public boolean isAggregate() {
        if (this.dim.isParentChildrenDimension()) {
            return this.def.aggregate;
        }
        return true;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }
}

