/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.BindVariants;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.expr.QueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNotExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.parser.SqlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class KsqlTextVariantsSolver {
    public static final Logger log = LogUtil.getPackageLogger(KsqlTextVariantsSolver.class);
    private Map params;
    private boolean simpleVarStyle;

    public KsqlTextVariantsSolver(HashMap params, boolean simpleVarStyle) {
        this.params = params;
        this.simpleVarStyle = simpleVarStyle;
    }

    public static final SqlSelect makeSqlSelect(String select) throws ParserException {
        Lexer lexer = new Lexer(select);
        SqlParser parser = new SqlParser(lexer);
        Collection c = parser.parseStmtList();
        SqlSelect sqlSelect = (SqlSelect)((SqlSelectStmt)c.iterator().next()).select;
        return sqlSelect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String solve(String sql, HashMap params, boolean simpleVarStyle) throws ParserException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("source:" + sql));
            log.debug((Object)("params:" + params));
            log.debug((Object)("simpleVarStyle:" + simpleVarStyle));
        }
        if (StringUtil.isEmptyString((String)sql)) {
            return sql;
        }
        KsqlTextVariantsSolver solver = new KsqlTextVariantsSolver(params, simpleVarStyle);
        String losql = sql.trim().toLowerCase();
        String result = "";
        if (!losql.startsWith("select")) {
            if (!losql.startsWith("where") && !losql.startsWith("order by")) throw new ParserException("unsupport sql text.[" + sql + "]");
            result = solver.solveEntityView(sql);
        } else {
            result = solver.solveSelect(sql).toString();
        }
        if (!log.isDebugEnabled()) return result;
        log.debug((Object)("result:" + result));
        return result;
    }

    private SqlExpr str2KsqlExpr(String exprStr) throws ParserException {
        Lexer lexer = new Lexer(exprStr);
        SqlExprParser parser = new SqlExprParser(lexer);
        SqlExpr expr = parser.expr();
        return expr;
    }

    private static void trimSqlIdentifierExpr(SqlIdentifierExpr expr) {
        String exprString = expr.value;
        if (exprString.charAt(0) == '\"') {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < exprString.length(); ++i) {
                if (exprString.charAt(i) == '\"') continue;
                sb.append(exprString.charAt(i));
            }
            expr.value = sb.toString();
        }
    }

    public static void covertSqlExpr_forEntityView(SqlExpr expr) {
        if (expr instanceof SqlIdentifierExpr) {
            KsqlTextVariantsSolver.trimSqlIdentifierExpr((SqlIdentifierExpr)expr);
            return;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(expr);
        while (!stack.isEmpty()) {
            SqlExpr subExpr = (SqlExpr)stack.pop();
            Field[] fields = subExpr.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field field = subExpr.getClass().getDeclaredField(fields[i].getName());
                    Object obj = field.get(subExpr);
                    if (obj == null || !SqlExpr.class.isAssignableFrom(obj.getClass())) continue;
                    if (obj instanceof SqlIdentifierExpr) {
                        KsqlTextVariantsSolver.trimSqlIdentifierExpr((SqlIdentifierExpr)obj);
                        continue;
                    }
                    if (obj instanceof SqlLongExpr || obj instanceof SqlIntExpr || obj instanceof SqlDoubleExpr || obj instanceof SqlDateTimeExpr || obj instanceof SqlNCharExpr || obj instanceof SqlCharExpr || obj instanceof SqlNullExpr) continue;
                    stack.push(obj);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String orderBys2Str_forEntityView(List orderBys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orderBys.size(); ++i) {
            SqlOrderByItem item = (SqlOrderByItem)orderBys.get(i);
            KsqlTextVariantsSolver.covertSqlExpr_forEntityView(item.expr);
            sb.append(item.expr.toString()).append(" ").append(item.mode == 0 ? "ASC" : "DESC");
            if (i == orderBys.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private SqlExpr solvePureSqlExpr(SqlExpr expr) {
        String exprStr = expr.toString();
        try {
            String newExprStr = BindVariants.replaceVariants(exprStr, this.params, this.simpleVarStyle);
            if (StringUtil.equals((String)newExprStr, (String)exprStr)) {
                return expr;
            }
            return this.str2KsqlExpr(newExprStr);
        }
        catch (Exception e) {
            log.info((Object)e);
            return UnkownBoolValueSqlExpr.instance;
        }
    }

    private SqlExpr solveWhere(SqlExpr expr) throws ParserException {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binOp = (SqlBinaryOpExpr)expr;
            if (binOp.operator == 7 || binOp.operator == 8) {
                binOp.left = this.solveWhere(binOp.left);
                binOp.right = this.solveWhere(binOp.right);
                if (binOp.left == UnkownBoolValueSqlExpr.instance) {
                    return binOp.right;
                }
                if (binOp.right == UnkownBoolValueSqlExpr.instance) {
                    return binOp.left;
                }
                return expr;
            }
        } else {
            if (expr instanceof SqlNotExpr) {
                SqlNotExpr notOp = (SqlNotExpr)expr;
                notOp.expr = this.solveWhere(notOp.expr);
                if (notOp.expr == UnkownBoolValueSqlExpr.instance) {
                    return UnkownBoolValueSqlExpr.instance;
                }
                return expr;
            }
            if (expr instanceof SqlInSubQueryExpr || expr instanceof SqlExistsExpr || expr instanceof QueryExpr) {
                SqlSelect subSelect = expr instanceof SqlInSubQueryExpr ? (SqlSelect)((SqlInSubQueryExpr)expr).subQuery : (expr instanceof SqlExistsExpr ? (SqlSelect)((SqlExistsExpr)expr).subQuery : (SqlSelect)((QueryExpr)expr).subQuery);
                if (subSelect.condition != null) {
                    subSelect.condition = this.solveWhere(subSelect.condition);
                    if (subSelect.condition == UnkownBoolValueSqlExpr.instance) {
                        subSelect.condition = null;
                    }
                }
                return expr;
            }
        }
        return this.solvePureSqlExpr(expr);
    }

    private void solveOrderBy(List orderBys) {
        if (orderBys == null) {
            return;
        }
        for (int i = 0; i < orderBys.size(); ++i) {
            SqlOrderByItem item = (SqlOrderByItem)orderBys.get(i);
            String exprStr = item.expr.toString();
            try {
                String newExprStr = BindVariants.replaceVariants(exprStr, this.params, this.simpleVarStyle);
                if (StringUtil.equals((String)newExprStr, (String)exprStr)) continue;
                item.expr = this.str2KsqlExpr(newExprStr);
                continue;
            }
            catch (Exception e) {
                orderBys.remove(i);
                --i;
            }
        }
    }

    private String solveEntityView(String viewStr) throws ParserException {
        if (viewStr == null || viewStr.length() == 0) {
            return viewStr;
        }
        SqlSelect select = (SqlSelect)this.solveSelect("SELECT * FROM T " + viewStr);
        viewStr = "";
        if (select.condition != null) {
            KsqlTextVariantsSolver.covertSqlExpr_forEntityView(select.condition);
            viewStr = "WHERE " + select.condition.toString() + " ";
        }
        if (select.orderBy != null && select.orderBy.size() > 0) {
            viewStr = viewStr + "ORDER BY " + this.orderBys2Str_forEntityView(select.orderBy);
        }
        return viewStr;
    }

    private SqlSelectBase solveSelect(String select) throws ParserException {
        SqlSelect sqlSelect = KsqlTextVariantsSolver.makeSqlSelect(select);
        this.solveSelect((SqlSelectBase)sqlSelect);
        return sqlSelect;
    }

    private void solveSelect(SqlSelectBase sqlSelectBase) throws ParserException {
        if (sqlSelectBase instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)sqlSelectBase;
            this.solveSelect(unionSelect.left);
            this.solveSelect(unionSelect.right);
            if (unionSelect.orderBy != null) {
                this.solveOrderBy(unionSelect.orderBy);
            }
        } else if (sqlSelectBase instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
            if (sqlSelect.condition != null) {
                SqlExpr newExpr = this.solveWhere(sqlSelect.condition);
                sqlSelect.condition = newExpr == UnkownBoolValueSqlExpr.instance ? null : newExpr;
            }
            this.solveSelectList(sqlSelect.selectList);
            this.solveSubQueryList(sqlSelect.subQueries);
            this.solveTableSource(sqlSelect.tableSource);
            this.solveOrderBy(sqlSelect.orderBy);
            if (sqlSelect.having != null) {
                this.solveWhere(sqlSelect.having);
            }
        }
    }

    private void solveTableSource(SqlTableSourceBase tableSource) throws ParserException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlSubQueryTableSource) {
            this.solveSelect(((SqlSubQueryTableSource)tableSource).subQuery);
        } else if (tableSource instanceof SqlJoinedTableSource) {
            this.solveTableSource(((SqlJoinedTableSource)tableSource).left);
            this.solveTableSource(((SqlJoinedTableSource)tableSource).right);
            this.solveWhere(((SqlJoinedTableSource)tableSource).condition);
        }
        this.solveSubQueryList(tableSource.subQueries);
    }

    private void solveSubQueryList(List subQueries) throws ParserException {
        if (subQueries == null) {
            return;
        }
        Iterator iter = subQueries.iterator();
        while (iter.hasNext()) {
            this.solveSelect((SqlSelectBase)iter.next());
        }
    }

    private void solveSelectList(List selectList) throws ParserException {
        if (selectList == null) {
            return;
        }
        for (SqlSelectItem item : selectList) {
            this.solveWhere(item.expr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTestSql() throws Exception {
        File file = new File("J:/testsql.txt");
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            BufferedReader br = new BufferedReader(reader);
            StringBuffer sb = new StringBuffer();
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] s) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("p", "p_value");
        String[] sqls = new String[]{"SELECT A,B,C FROM D WHERE (A>@p1) AND (B=1) AND (C LIKE '%c@p2')", "SELECT A,B,C FROM D WHERE (A>@p1) AND (B=1) OR (C LIKE '%c@p2')", "SELECT A,B,C FROM D WHERE (A>@p) AND (B=1 OR C<>@p1)", "SELECT A,B,C FROM D WHERE '123@p1'=A AND (NOT (1+@p1=1))", "SELECT A,B,C FROM D WHERE NOT(1+@p1=1)", "SELECT A,B,C FROM D WHERE A IN ('/','/eas')", "SELECT A FROM D WHERE A IN (SELECT A FROM D WHERE B=@p1 AND C=@p) ORDER BY A ASC", "SELECT A FROM D WHERE A IN (SELECT A FROM D WHERE B=@p1 AND C='@p') ORDER BY @q1 ASC,@p ASC", "SELECT A,B,C FROM D WHERE A=@p AND A<>@q OR A<>@x", "where number<>'@p' and ttt<>'@p'", "where number<>'@p' and number>'@p'"};
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("Year", new Integer(2007));
        param.put("Period", new Integer(4));
        String sql = KsqlTextVariantsSolver.solve(KsqlTextVariantsSolver.getTestSql(), param, true);
        System.out.println(sql);
    }

    private static class UnkownBoolValueSqlExpr
    extends SqlExpr {
        private static final UnkownBoolValueSqlExpr instance = new UnkownBoolValueSqlExpr();

        private UnkownBoolValueSqlExpr() {
            super(Short.MAX_VALUE);
        }
    }
}

