/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine.resultset;

import com.kingdee.bos.ctrl.reportone.data.engine.resultset.BasicResultSet;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IRowNode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleResultSet
extends BasicResultSet
implements ResultSet {
    private ResultSetMetaData metaData;
    protected Object[] datas;
    protected int totalRecords;
    protected int fetched;
    protected int columns = -1;
    protected IRowNode curNode;

    public SimpleResultSet(IRowNode firstRecord, int count, ResultSetMetaData meta) {
        this.metaData = meta;
        this.totalRecords = count;
        this.fetched = 0;
        this.curNode = firstRecord;
    }

    @Override
    public Object getObject(int column) throws SQLException {
        super.checkCursor(false);
        if (this.columns == -1) {
            this.columns = this.metaData.getColumnCount();
        }
        if (column < 1 || column > this.columns) {
            throw new SQLException("Bad column index:" + column);
        }
        this.ensureRowData();
        return this.datas[column - 1];
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    protected void ensureRowData() throws SQLException {
        if (this.datas == null) {
            if (this.curNode == null) {
                throw new SQLException("Internal error: 'Current node lost!'.");
            }
            this.datas = this.curNode.getRowData();
        }
    }

    @Override
    public boolean next() throws SQLException {
        super.checkCursor(true);
        if (this.fetched++ >= this.totalRecords) {
            this.cursorStatus = -2;
        } else {
            this.datas = null;
            if (this.curNode != null && this.fetched != 1) {
                this.curNode = this.curNode.nextRow();
            }
        }
        return this.cursorStatus != -2;
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return null;
    }
}

