/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.modal.query;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;

public class QueryType {
    private String name;
    private String alias;
    public static final String CAPITAL_SQL = "sql";
    public static final QueryType SQL_WIZARD = new QueryType("sql.wizard", "SQL");
    public static final QueryType SQL_CUSTOM = new QueryType("sql.custom", QueryType.getMLS("customSQL", "\u81ea\u5b9a\u4e49SQL"));
    public static final String CAPITAL_BOS = "bos";
    public static final QueryType BOS_QUERY = new QueryType("bos.query", QueryType.getMLS("bosQuery", "BOS\u67e5\u8be2"));
    public static final QueryType BOS_ENTITY = new QueryType("bos.entity", QueryType.getMLS("bosEntiy", "BOS\u5b9e\u4f53"));

    private QueryType(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.alias;
    }

    public String getCapital() {
        int dotIdx = this.name.indexOf(".");
        if (dotIdx < 0 || dotIdx == this.name.length() - 1) {
            return this.name;
        }
        return this.name.substring(0, dotIdx);
    }

    public static QueryType fromName(String name) {
        if (SQL_WIZARD.getName().equals(name)) {
            return SQL_WIZARD;
        }
        if (SQL_CUSTOM.getName().equals(name)) {
            return SQL_CUSTOM;
        }
        if (BOS_QUERY.getName().equals(name)) {
            return BOS_QUERY;
        }
        if (BOS_ENTITY.getName().equals(name)) {
            return BOS_ENTITY;
        }
        return null;
    }

    private static String getMLS(String key, String defaultValue) {
        String res = CtrlClassUtil.getPackageName(QueryType.class) + ".querytype";
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }
}

