/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.AVG;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.COUNT;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.IAggregate;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.MAX;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.MIN;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.SUM;
import java.util.HashMap;

public class Aggregates {
    private static final HashMap funcsMap = new HashMap();

    public static final String[] aggregates() {
        String[] t = new String[funcsMap.keySet().size()];
        funcsMap.keySet().toArray(t);
        return t;
    }

    public static IAggregate getInstance(String name) {
        try {
            return (IAggregate)((Class)funcsMap.get(name)).newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isSupported(String method, DataType dt) {
        if ("count".equals(method)) {
            return true;
        }
        if (DataType.isNumberType((DataType)dt)) {
            return true;
        }
        if (DataType.DATETIME == dt || DataType.STRING == dt || DataType.BOOLEAN == dt) {
            return method.equals("min") || method.equals("max");
        }
        return false;
    }

    public static String getDefaultTotalMethod(DataType dt) {
        if (DataType.isNumberType((DataType)dt)) {
            return "sum";
        }
        return "count";
    }

    static {
        funcsMap.put("sum", SUM.class);
        funcsMap.put("avg", AVG.class);
        funcsMap.put("min", MIN.class);
        funcsMap.put("max", MAX.class);
        funcsMap.put("count", COUNT.class);
    }
}

