/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.dataprocess;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaManager;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.MetaClassSelectTree;
import com.kingdee.bos.ctrl.reportone.data.modal.IDataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.Import;
import com.kingdee.bos.ctrl.reportone.data.modal.Imports;
import com.kingdee.bos.ctrl.reportone.data.wizard.dataprocess.DataprocessResource;
import com.kingdee.bos.ctrl.reportone.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class ImportSelector
extends KDPanel {
    private NormalSelector selector;
    private JComponent supply;
    private IObjectSelector provider;

    public ImportSelector() {
        this.setOpaque(false);
        this.init();
    }

    private void init() {
        this.selector = new NormalSelector(){

            protected void onSelect() {
                ImportSelector.this.onSelect();
            }

            protected void onSelectAll() {
                ImportSelector.this.onSelectAll();
            }

            protected void syncListViewButton() {
                super.syncListViewButton();
                if (this.getSelectedList().getSelectedIndex() == -1 || this.getSelectedList().getSelectedIndices().length > 1) {
                    this.lvSelected.getButton("edit").setEnabled(false);
                } else {
                    this.lvSelected.getButton("edit").setEnabled(true);
                }
            }
        };
        this.selector.setSupplyTitle(this.getMLS("leftTitle0", DataprocessResource.getString("res_16")));
        this.selector.setSelectedTitle(this.getMLS("rightTitle0", DataprocessResource.getString("res_17")));
        this.selector.getSelected().syncBtn();
        TableLayout tl = TableLayout.split((int)1, (int)1);
        tl.rowStyle(0).setPriY(1);
        tl.rowStyle(0).setMarginBottom(8);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.selector, tl.cell(0));
    }

    private void onSelect() {
        this.addImport(this.provider.getSelectedInfo());
    }

    public boolean addImport(String fp) {
        if (fp == null) {
            return false;
        }
        MetaClass mc = (MetaClass)this.provider.getObject(fp);
        if (mc == null) {
            return false;
        }
        KDList kdList = this.getSelector().getSelected().getList();
        for (int i = 0; i < kdList.getElementCount(); ++i) {
            Import importObj = (Import)((Object)kdList.getElement(i));
            if (!importObj.getExpr().equals(fp)) continue;
            return false;
        }
        Import importObj = new Import();
        importObj.setAlias(mc.getAlias());
        importObj.setName(mc.getName());
        importObj.setExpr(fp);
        WizardUtil.makeSureDefObjUnique(this.selector.getSelectedList(), importObj);
        kdList.addElement((Object)importObj);
        kdList.setSelectedValue((Object)importObj, true);
        return true;
    }

    private void onSelectAll() {
    }

    public Imports getImports() {
        Imports imports = new Imports();
        for (int i = 0; i < this.selector.getSelectedList().getElementCount(); ++i) {
            imports.add(this.selector.getSelectedList().getElement(i));
        }
        return imports;
    }

    public NormalSelector getSelector() {
        return this.selector;
    }

    public void showValue(IDataDef dataObj) {
        KDList kdList = this.selector.getSelectedList();
        kdList.removeAllElements();
        Imports list = dataObj.getImports();
        if (list == null) {
            return;
        }
        for (Import importObj : list) {
            this.addImport(importObj.getExpr());
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        ImportSelector s = new ImportSelector();
        s.setProvider((IObjectSelector)new MetaClassSelectTree(new MetaManager()));
        KDFrame f = new KDFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.getContentPane().add((Component)((Object)s));
        f.show();
    }

    public IObjectSelector getProvider() {
        return this.provider;
    }

    public void setProvider(IObjectSelector provider) {
        this.provider = provider;
        this.supply = provider.getUI();
        this.selector.setSupplyCtrlNoScroll(this.supply);
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.data.wizard.dataprocess.dataprocess", (String)defaultValue);
    }
}

