/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.query;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.data.modal.Outputs;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.wizard.framework.datadef.DefaultCommonQueryWizardModel;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.ui.DefaultArgInputUI;
import com.kingdee.bos.ctrl.reportone.reportimpl.xdata.DataBindUtil;
import com.kingdee.bos.ctrl.reportone.reportimpl.xquery.IXQueryRptExecutor;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class PreviewKSQLPanel
extends KDPanel {
    private KDSpinner spnTop = new KDSpinner((SpinnerModel)new SpinnerNumberModel(50, 1, 1000, 1));
    private KDWorkButton btMakeOutputs = new KDWorkButton("\u751f\u6210\u8f93\u51fa\u5b57\u6bb5");
    private KDWorkButton btSettingArgs = new KDWorkButton("\u8bbe\u7f6e\u53c2\u6570");
    private KDWorkButton btPreview = new KDWorkButton("\u5237\u65b0");
    private KDTable tblContent = new KDTable();
    private OutputColumns outputColumns;
    private HashMap previewArgs;
    private DefaultArgInputUI argsUI;
    private boolean outputsModified = false;
    private DefaultCommonQueryWizardModel model;

    public PreviewKSQLPanel() {
        TableLayout layout = TableLayout.splitRow((int)2);
        this.setLayout((LayoutManager)layout);
        KDLabel labPrompt1 = new KDLabel("\u6700\u5927\u8bb0\u5f55\u6761\u6570: ");
        Table top = layout.cell(0).splitCol(6);
        this.add((Component)labPrompt1, top.cell(1));
        this.add((Component)this.spnTop, top.cell(2));
        this.add((Component)this.btSettingArgs, top.cell(3));
        this.add((Component)this.btMakeOutputs, top.cell(4));
        this.add((Component)this.btPreview, top.cell(5));
        top.colStyle(0).setPriX(1);
        top.colStyle(1).setWidth(45);
        top.colStyle(2).setWidth(60);
        top.colStyle(3).setWidth(80);
        top.colStyle(4).setWidth(80);
        top.colStyle(5).setWidth(80);
        top.colStyle(2).setMarginRight(3);
        top.colStyle(3).setMarginRight(3);
        top.colStyle(4).setMarginRight(3);
        this.add((Component)this.tblContent, layout.cell(1));
        layout.rowStyle(0).setMarginBottom(3);
        layout.rowStyle(1).setPriY(1);
        this.btMakeOutputs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreviewKSQLPanel.this.outputColumns == null) {
                    return;
                }
                PreviewKSQLPanel.this.outputsModified = true;
                DefaultCommonQueryWizardModel model = PreviewKSQLPanel.this.getModel();
                Outputs outputs = model.getCommonQuery().getOutputs();
                if (outputs != null) {
                    outputs.clear();
                } else {
                    outputs = new Outputs();
                    model.getCommonQuery().setOutputs(outputs);
                }
                outputs.add(PreviewKSQLPanel.this.outputColumns);
            }
        });
        this.btPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PreviewKSQLPanel.this.preview();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.btSettingArgs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCommonQueryWizardModel model = PreviewKSQLPanel.this.getModel();
                if (PreviewKSQLPanel.this.argsUI == null) {
                    PreviewKSQLPanel.this.argsUI = new DefaultArgInputUI();
                    PreviewKSQLPanel.this.argsUI.setSize(480, 240);
                }
                PreviewKSQLPanel.this.argsUI.setParameters(model.getCommonQuery().getParameters(), PreviewKSQLPanel.this.previewArgs);
                if (WindowUtil.showSimpleDialog((Component)((Object)PreviewKSQLPanel.this.argsUI), (Component)PreviewKSQLPanel.this.btSettingArgs, (String)"\u9884\u89c8\u53c2\u6570", null)) {
                    PreviewKSQLPanel.this.previewArgs = PreviewKSQLPanel.this.argsUI.getInputArgs();
                }
            }
        });
    }

    private int getTopNumber() {
        return this.spnTop.getIntegerVlaue();
    }

    private HashMap getPreviewArgs() {
        if (this.previewArgs == null) {
            DefaultCommonQueryWizardModel model = this.getModel();
            List list = model.getCommonQuery().getParameters();
            HashMap args = ParamUtil.makeDefaultArgs2(list);
            this.previewArgs = args == null ? new HashMap() : args;
        }
        return this.previewArgs;
    }

    private void clearRows() {
        this.outputColumns = null;
        this.tblContent.removeColumns();
    }

    private int addResultSet(ResultSet rs) throws SQLException {
        if (this.outputColumns == null) {
            this.outputColumns = PreviewKSQLPanel.parseRSMD(rs.getMetaData());
            DataBindUtil.bindResultSet(this.tblContent, rs, false, true);
        }
        return DataBindUtil.bindResultSet(this.tblContent, rs, true, false);
    }

    public void preview() throws Exception {
        DefaultCommonQueryWizardModel model = this.getModel();
        IXQueryRptExecutor executor = model.getXQueryExecutor();
        try {
            this.clearRows();
            executor.execute(this.getPreviewArgs());
            int rowCount = this.getTopNumber();
            int pageSize = 100;
            if (rowCount == -1) {
                rowCount = Integer.MAX_VALUE;
            }
            if (rowCount < 100) {
                pageSize = rowCount;
            }
            do {
                IRowSet rs;
                if (this.addResultSet((ResultSet)(rs = executor.nextPage(pageSize))) == 0) {
                    rowCount = 0;
                }
                rs.close();
            } while ((rowCount -= pageSize) > 0);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                executor.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final DefaultCommonQueryWizardModel getModel() {
        return this.model;
    }

    public final void setModel(DefaultCommonQueryWizardModel model) {
        this.model = model;
    }

    public static OutputColumns parseRSMD(ResultSetMetaData rsmd) throws SQLException {
        OutputColumns columns = new OutputColumns();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String name = rsmd.getColumnName(i + 1);
            DataType dt = DataType.fromJdbcType((int)rsmd.getColumnType(i + 1));
            OutputColumn oc = new OutputColumn();
            oc.setName(name);
            oc.setDataType(dt);
            columns.add(oc);
        }
        return columns;
    }

    public final boolean isOutputsModified() {
        return this.outputsModified;
    }
}

