/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UnsupportedOperationException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.BasicRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.ILazyFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.PersistentMetas;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipSpaceProvider
implements ISpaceProvider {
    private ZipFile zipFileObj;
    private EntryNode root = new EntryNode();

    private static void zip(String name_string, File file, ZipOutputStream zipOutput) throws IOException {
        ZipEntry entry = new ZipEntry(name_string + (file.isDirectory() ? "/" : ""));
        if (file.isFile()) {
            zipOutput.putNextEntry(entry);
            FileInputStream fin = new FileInputStream(file);
            byte[] data = CtrlUtil.Stream.readInputStream((InputStream)fin);
            ((InputStream)fin).close();
            zipOutput.write(data, 0, data.length);
            zipOutput.closeEntry();
        } else {
            zipOutput.putNextEntry(entry);
            zipOutput.closeEntry();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ZipSpaceProvider.zip(name_string + "/" + files[i].getName(), files[i], zipOutput);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String sourceFilePath, String zipFilePath, boolean onlyContent) throws IOException {
        File file = new File(sourceFilePath);
        ZipOutputStream zipOutput = null;
        try {
            FileOutputStream fout = new FileOutputStream(zipFilePath);
            zipOutput = new ZipOutputStream(fout);
            File[] files = new File[]{file};
            if (onlyContent) {
                files = file.listFiles();
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ZipSpaceProvider.zip(files[i].getName(), files[i], zipOutput);
                }
            }
        }
        finally {
            if (zipOutput != null) {
                try {
                    zipOutput.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public ZipSpaceProvider(String zipFilePath) throws IOException {
        this.initEntries(new ZipFile(zipFilePath));
    }

    private void initEntry(ZipEntry entry) {
        EntryNode parentNode = this.root;
        String name = entry.getName();
        boolean isFile = true;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
            isFile = false;
        }
        Path[] pathx = Path.valueOf("/" + name).paths();
        for (int i = 1; i < pathx.length; ++i) {
            EntryNode current = parentNode.getChild(pathx[i].getName(), true);
            if (i == pathx.length - 1) {
                current.entry = entry;
                current.isFile = isFile;
            } else {
                current.isFile = false;
            }
            parentNode = current;
        }
    }

    private void initEntries(ZipFile zipFileObj) {
        this.root.init();
        this.zipFileObj = zipFileObj;
        Enumeration<? extends ZipEntry> enus = zipFileObj.entries();
        while (enus.hasMoreElements()) {
            this.initEntry(enus.nextElement());
        }
    }

    @Override
    public int exist(Path resPath) throws KDRSException {
        try {
            EntryNode node = this.check(resPath);
            return node.isFile ? 1 : 2;
        }
        catch (NotFoundException e) {
            return 0;
        }
    }

    @Override
    public HashMap list(Path resPath) throws KDRSException {
        EntryNode node = this.check(resPath);
        if (node.isFile) {
            throw new UnsupportedOperationException("Couldn't support 'list' on file type resource.");
        }
        HashMap<String, ResourceType> rs = new HashMap<String, ResourceType>();
        if (node.children != null) {
            Iterator keys = node.children.keySet().iterator();
            Iterator vals = node.children.values().iterator();
            while (keys.hasNext()) {
                String childName = (String)keys.next();
                EntryNode child = (EntryNode)vals.next();
                rs.put(childName, child.isFile ? ResourceType.FILE : ResourceType.FOLDER);
            }
        }
        return rs;
    }

    EntryNode check(Path path) throws KDRSException {
        EntryNode node = this.root;
        Path[] pathx = path.paths();
        for (int i = 1; i < pathx.length; ++i) {
            EntryNode temp = node.getChild(pathx[i].getName(), false);
            if (temp == null) {
                throw new NotFoundException("Not found resource " + pathx[i]);
            }
            node = temp;
        }
        return node;
    }

    @Override
    public IRandomAccessStream openStream(Path resPath, boolean clear, boolean autoCreate, boolean readOnly) throws KDRSException {
        EntryNode node = this.check(resPath);
        if (!node.isFile) {
            throw new UnsupportedOperationException("Couldn't support 'openStream' on folder type resource.");
        }
        try {
            return new RandomAccessStream(node.entry, this.zipFileObj);
        }
        catch (IOException ex) {
            throw KDRSException.makeException("", ex);
        }
    }

    @Override
    public void rename(Path resPath, String newName) throws KDRSException {
        throw new KDRSException("Unsupported.");
    }

    @Override
    public void move(Path resPath, Path newPath) throws KDRSException {
        throw new KDRSException("Unsupported.");
    }

    @Override
    public int getLength(Path resPath) throws KDRSException {
        throw new KDRSException("Unsupported.");
    }

    @Override
    public void copyFile(Path fromPath, Path toPath) throws KDRSException {
        throw new KDRSException("Unsupported.");
    }

    @Override
    public void free(Path resPath) throws KDRSException {
        throw new KDRSException("Unsupported.");
    }

    @Override
    public void allocate(Path resPath, boolean isFile) throws KDRSException {
        throw new KDRSException("Unsupported.");
    }

    public static void main(String[] args) throws Exception {
        ZipSpaceProvider.zip("c:\\dd", "c:\\dd1.zip", false);
        ZipSpaceProvider.zip("c:\\dd", "c:\\dd2.zip", true);
    }

    public static class ZipEntryPersistentMetas
    extends PersistentMetas {
        public ZipEntryPersistentMetas(ISpaceProvider space) throws KDRSException {
            super(space);
        }

        @Override
        protected void saveResourcesMeta(Path metaPath, Iterator children) throws KDRSException {
        }

        @Override
        public void updateFolderMeta(Path folderPath, ILazyFolderMeta folderMeta) throws KDRSException {
        }

        @Override
        public void updateMeta(Path resPath, IResourceMeta meta) throws KDRSException {
        }
    }

    class RandomAccessStream
    extends BasicRandomAccessStream {
        int position = 0;
        InputStream low_stream;
        ZipEntry entry;

        RandomAccessStream(ZipEntry entry, ZipFile zipFileObj) throws IOException {
            this.low_stream = zipFileObj.getInputStream(entry);
        }

        @Override
        public long length() throws IOException {
            return this.entry.getSize();
        }

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public int read() throws IOException {
            int r = this.low_stream.read();
            if (r != -1) {
                ++this.position;
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count = this.low_stream.read(b, off, len);
            if (count != -1) {
                this.position += count;
            }
            return count;
        }

        @Override
        public void seek(long pos) throws IOException {
            this.low_stream.skip(pos - (long)this.position);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new IOException("Read only");
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Read only");
        }
    }

    private class EntryNode {
        ZipEntry entry;
        Map children;
        boolean isFile;

        private EntryNode() {
        }

        void init() {
            this.entry = null;
            this.children = new HashMap();
            this.isFile = false;
        }

        EntryNode getChild(String child, boolean autoCreate) {
            EntryNode childNode = null;
            if (this.children != null) {
                childNode = (EntryNode)this.children.get(child);
            }
            if (childNode == null && autoCreate) {
                if (this.children == null) {
                    this.init();
                }
                childNode = new EntryNode();
                this.children.put(child, childNode);
            }
            return childNode;
        }
    }
}

