/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.ui;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class DefaultArgInputUI
extends KDPanel {
    private static final int COL_TITLE = 0;
    private static final int COL_INPUT = 1;
    private static final int COL_DESC = 2;
    private List params;
    private KDTable table;
    private boolean isChanged = false;
    private HashMap cellEditors = new HashMap();
    private KDPromptSelector dataViewInput;

    public DefaultArgInputUI() {
        this.init();
    }

    public final KDPromptSelector getDataViewInput() {
        return this.dataViewInput;
    }

    public final void setDataViewInput(KDPromptSelector dataViewInput) {
        this.dataViewInput = dataViewInput;
    }

    private ICellEditor getCellEditor(Parameter p) {
        DataType dataType = p.getDataType();
        ICellEditor cellEditor = (ICellEditor)this.cellEditors.get(dataType);
        if (cellEditor == null) {
            if (DataType.INTEGER == dataType || DataType.DOUBLE == dataType || DataType.DECIMAL == dataType) {
                cellEditor = new KDTDefaultCellEditor((JTextField)new KDNumberTextField());
            } else if (DataType.BOOLEAN == dataType) {
                cellEditor = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
            } else if (DataType.DATETIME == dataType) {
                cellEditor = new KDTDefaultCellEditor(new KDDatePicker());
            } else if (DataType.STRING == dataType && "true".equals(p.getProperty(Parameter.P_isDataView.getName())) && this.dataViewInput != null) {
                KDPromptBox pbx = new KDPromptBox();
                pbx.setSelector(this.dataViewInput);
                cellEditor = new KDTDefaultCellEditor((IKDEditor)pbx);
            }
            this.cellEditors.put(dataType, cellEditor);
        }
        return cellEditor;
    }

    public void setParameters(List ps, Map args) {
        this.params = ps;
        this.isChanged = false;
        this.table.removeRows();
        if (this.params != null) {
            int z = this.params.size();
            for (int i = 0; i < z; ++i) {
                Parameter p = (Parameter)this.params.get(i);
                String defVal = null;
                if (args != null) {
                    defVal = (String)args.get(p.getName());
                }
                if (defVal == null) {
                    defVal = p.getDefaultValue();
                }
                this.addParam2Row(p, defVal);
            }
        }
    }

    private void init() {
        this.setOpaque(false);
        this.initTable();
        TableLayout tl = TableLayout.split((int)1, (int)1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.table, tl.cell(0));
    }

    private void initTable() {
        this.table = new KDTable();
        this.table.addColumns(3);
        this.table.getColumn(0).setWidth(80);
        this.table.getColumn(1).setWidth(100);
        this.table.getColumn(2).setWidth(240);
        this.table.getColumn(0).getStyleAttributes().setLocked(true);
        this.table.getColumn(2).getStyleAttributes().setLocked(true);
        this.table.getColumn(2).getStyleAttributes().setFontColor(Color.GRAY);
        IRow row = this.table.addHeadRow();
        row.getCell(0).setValue((Object)ClientResource.getString("res_78"));
        row.getCell(1).setValue((Object)ClientResource.getString("res_79"));
        row.getCell(2).setValue((Object)ClientResource.getString("res_72"));
    }

    private void addParam2Row(Parameter p, String defVal) {
        IRow row = this.table.addRow();
        Object cellVal = defVal;
        DataType dataType = p.getDataType();
        if (dataType != null) {
            row.getCell(1).setEditor(this.getCellEditor(p));
            if (DataType.DATETIME == dataType) {
                row.getCell(1).getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
                if (!StringUtil.isEmptyString((String)defVal)) {
                    try {
                        cellVal = DateFormat.getDateInstance().parse(defVal);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        row.getCell(0).setValue((Object)p.getAliasName());
        row.getCell(2).setValue((Object)p.getDesc());
        row.getCell(1).setValue(cellVal);
    }

    public boolean verify() {
        String pValue = "";
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            Parameter p = (Parameter)this.params.get(i);
            pValue = row.getCell(1).getValue() != null ? row.getCell(1).getValue().toString() : "";
            if (p.isAllowNull() || !"".equals(pValue.trim())) continue;
            WindowUtil.msgboxError((Object)(p.getAlias() + ClientResource.getString("res_80")), (String)ClientResource.getString("res_78"), (Component)((Object)this));
            return false;
        }
        return true;
    }

    private static Object getRowInputValue(IRow row) {
        Object val = row.getCell(1).getValue();
        if (val instanceof Date) {
            return DateFormat.getDateInstance().format((Date)val);
        }
        return val;
    }

    public Object getArg(String name) {
        int idx = ParamUtil.indexOfParameter(this.params, name);
        if (idx == -1) {
            return null;
        }
        return DefaultArgInputUI.getRowInputValue(this.table.getRow(idx));
    }

    public HashMap getExecArgs() {
        HashMap args = this.getInputArgs();
        ParamUtil.makeExecArgs(args, args);
        return args;
    }

    public HashMap getInputArgs() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            Parameter p = (Parameter)this.params.get(i);
            map.put(p.getName(), DefaultArgInputUI.getRowInputValue(row));
        }
        return map;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public final List getParams() {
        return this.params;
    }
}

