/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.objectx;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class TypesConfigure {
    public static final Logger log = LogUtil.getLogger(TypesConfigure.class);
    private HashMap type2Mapping = new HashMap();
    private HashMap cls2Mapping = new HashMap();
    private HashMap impl2Mapping = new HashMap();
    public static final String ATTR_OBJ_INTERFACE = "type-interface";
    public static final String ATTR_OBJ_CLASS = "type-class";

    public void load(Map typesConf) throws Exception {
        Iterator keys = typesConf.keySet().iterator();
        Iterator vals = typesConf.values().iterator();
        while (keys.hasNext()) {
            try {
                String type = (String)keys.next();
                HashMap defs = (HashMap)vals.next();
                Object value = defs.get(ATTR_OBJ_INTERFACE);
                Class<?> typeInterface = value instanceof String ? Class.forName((String)value) : (Class<?>)value;
                value = defs.get(ATTR_OBJ_CLASS);
                Class<?> typeClass = value instanceof String ? Class.forName((String)value) : (Class<?>)value;
                TypeMapping tm = new TypeMapping(type, typeInterface, typeClass);
                this.type2Mapping.put(type, tm);
                this.cls2Mapping.put(typeInterface, tm);
                this.impl2Mapping.put(typeClass, tm);
                log.info((Object)("Loading type:" + type + ",interface=" + typeInterface + ",class=" + typeClass));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public TypeMapping findByType(String type) {
        return (TypeMapping)this.type2Mapping.get(type);
    }

    public TypeMapping findByType(Class cls) {
        return (TypeMapping)this.cls2Mapping.get(cls);
    }

    public TypeMapping findByImplType(Class cls) {
        return (TypeMapping)this.impl2Mapping.get(cls);
    }

    public static class TypeMapping {
        private Class objType;
        private Class typeImpl;
        private String type;

        public TypeMapping(String type, Class objType, Class typeImpl) {
            this.objType = objType;
            this.typeImpl = typeImpl;
            this.type = type;
        }

        public Class getObjType() {
            return this.objType;
        }

        public String getType() {
            return this.type;
        }

        public Class getTypeImpl() {
            return this.typeImpl;
        }
    }
}

