/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import java.util.HashMap;

public class StorageProxy
implements IStorage {
    private IStorage impl;
    private Path basePath;

    public StorageProxy(IStorage impl, Path basePath) {
        this.impl = impl;
        this.basePath = basePath;
    }

    private Path getAbsolutePath(Path resPath) {
        return Path.contact(this.basePath, resPath);
    }

    @Override
    public void copyFile(Path source, Path target) throws KDRSException {
        this.impl.copyFile(this.getAbsolutePath(source), this.getAbsolutePath(target));
    }

    @Override
    public void create(Path path, ResourceType type, HashMap attributes) throws KDRSException {
        this.impl.create(this.getAbsolutePath(path), type, attributes);
    }

    @Override
    public void delete(Path path) throws KDRSException {
        this.impl.delete(this.getAbsolutePath(path));
    }

    @Override
    public Object getAttribute(Path path, String attrName) throws KDRSException {
        return this.impl.getAttribute(this.getAbsolutePath(path), attrName);
    }

    @Override
    public HashMap getAttributes(Path path) throws KDRSException {
        return this.impl.getAttributes(this.getAbsolutePath(path));
    }

    @Override
    public int getFileLength(Path path) throws KDRSException {
        return this.impl.getFileLength(this.getAbsolutePath(path));
    }

    @Override
    public IRandomAccessStream getFileStream(Path path, boolean clear, boolean readOnly) throws KDRSException {
        return this.impl.getFileStream(this.getAbsolutePath(path), clear, readOnly);
    }

    @Override
    public ResourceType getType(Path path) throws KDRSException {
        return this.impl.getType(this.getAbsolutePath(path));
    }

    @Override
    public boolean isExist(Path path) throws KDRSException {
        return this.impl.isExist(this.getAbsolutePath(path));
    }

    @Override
    public String[] listChildren(Path path) throws KDRSException {
        return this.impl.listChildren(this.getAbsolutePath(path));
    }

    @Override
    public void move(Path path1, Path path2) throws KDRSException {
        this.impl.move(this.getAbsolutePath(path1), this.getAbsolutePath(path2));
    }

    @Override
    public void refresh(Path path, boolean recursion) throws KDRSException {
        this.impl.refresh(this.getAbsolutePath(path), recursion);
    }

    @Override
    public void rename(Path path, String newName) throws KDRSException {
        this.impl.rename(this.getAbsolutePath(path), newName);
    }

    @Override
    public void setAttribute(Path path, String attrName, Object attrValue) throws KDRSException {
        this.impl.setAttribute(this.getAbsolutePath(path), attrName, attrValue);
    }

    @Override
    public void setAttributes(Path path, HashMap attributes) throws KDRSException {
        if (path.isRoot() && attributes != null && "".equals(attributes.get("name"))) {
            attributes.remove("name");
        }
        this.impl.setAttributes(this.getAbsolutePath(path), attributes);
    }

    public String toString() {
        return this.basePath + "|" + this.impl.toString();
    }

    public boolean equals(Object obj) {
        boolean b = super.equals(obj);
        if (!b && obj instanceof StorageProxy) {
            StorageProxy proxy = (StorageProxy)obj;
            b = CtrlUtil.Obj.equals((Object)proxy.basePath, (Object)this.basePath) && CtrlUtil.Obj.equals((Object)proxy.impl, (Object)this.impl);
        }
        return b;
    }
}

