/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.toolbar;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.menu.IR1DesignerAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.format.StyleOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.toolbar.ISimilarAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.StateChangedEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.AbstractR1Designer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.event.FontChangeEvent;
import com.kingdee.bos.ctrl.swing.event.FontChangeListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;

public class FontAction
implements IR1DesignerAction,
ISimilarAction {
    private KDFontChooser _ctrl;
    private AbstractR1Designer _designer;
    private boolean _notFireFontChange = false;

    @Override
    public void setBindCtrl(JComponent ctrl) {
        if (!(ctrl instanceof KDFontChooser)) {
            throw new R1DesignerRuntimeException("Ctrl must be KDFontChooser.");
        }
        this._ctrl = (KDFontChooser)ctrl;
        EventHandler eventHandler = new EventHandler();
        this._ctrl.getSelectionModel().addChangeListener((FontChangeListener)eventHandler);
    }

    @Override
    public void setDesigner(AbstractR1Designer designer) {
        this._designer = designer;
    }

    @Override
    public AbstractR1Designer getDesigner() {
        return this._designer;
    }

    @Override
    public void todoStateChanged(StateChangedEvent evt) {
        if (evt.getState().isStateMark(4096L)) {
            this._ctrl.setEnabled(true);
        } else {
            this._ctrl.setEnabled(false);
        }
    }

    @Override
    public void todoSelectionChanged(ChangeEvent evt) {
        ElementPath[] eps = this.getDesigner().getCore().getSelectionModel().getAll();
        StyleAttributes mixedFullSa = StyleOperate.mixFullSa(eps);
        this.syncCtrl(mixedFullSa);
        this._ctrl.setEnabled(this.isEnabled(this.getDesigner().getCore()));
    }

    protected void syncCtrl(StyleAttributes sa) {
        this._notFireFontChange = true;
        String fontName = null;
        int fontSize = -1;
        int fontStyle = 0;
        if (!sa.isUnsureValue(StyleAttributes.FONT_NAME)) {
            fontName = sa.getFontName();
        }
        if (!sa.isUnsureValue(StyleAttributes.FONT_SIZE)) {
            fontSize = sa.getFontSize();
        }
        if (!sa.isUnsureValue(StyleAttributes.FONT_BOLD) && sa.isBold()) {
            ++fontStyle;
        }
        if (!sa.isUnsureValue(StyleAttributes.FONT_ITALIC) && sa.isItalic()) {
            fontStyle += 2;
        }
        this._ctrl.setSelectionFontWithUnsure(fontName, fontStyle, fontSize);
        this._notFireFontChange = false;
    }

    protected boolean isEnabled(ComboPanel core) {
        ElementPath epa = this.getDesigner().getCore().getSelectionModel().getCurrent();
        return !(epa.getLastPathComponent() instanceof IR1Page);
    }

    class EventHandler
    implements FontChangeListener {
        EventHandler() {
        }

        public void fontChanged(FontChangeEvent e) {
            if (FontAction.this._notFireFontChange) {
                return;
            }
            ElementPath[] eps = FontAction.this.getDesigner().getCore().getSelectionModel().getAll();
            for (int i = 0; i < eps.length; ++i) {
                IElement ele = (IElement)eps[i].getLastPathComponent();
                StyleAttributes sa = ele.getNotNullSA();
                sa.clearDirtyFlag();
                if (e.isFamilyChanged()) {
                    sa.setFontName(e.getNewFamily());
                }
                if (e.isSizeChanged()) {
                    sa.setFontSize(e.getNewSize());
                }
                if (e.isStyleChanged()) {
                    sa.setBold((e.getNewStyle() & 1) == 1);
                    sa.setItalic((e.getNewStyle() & 2) == 2);
                }
                ele.setStyleAttribute(sa);
                Object objRo = eps[i].getRootPathComponent();
                if (!(objRo instanceof ICompositeObject)) continue;
                ((ICompositeObject)objRo).applySubElementStyle(ele, sa);
            }
            FontAction.this.getDesigner().getCore().getModel().setDirty(true);
            FontAction.this.getDesigner().getCore().getPageContainer().repaint();
        }
    }
}

