/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.clipboard;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.properties.IRequestFill;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.clipboard.IR1Clipboard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class R1Clipboard
implements IR1Clipboard {
    protected static final Logger log = LogUtil.getLogger(R1Clipboard.class);
    protected ComboPanel _core;
    protected ReportSelectionModel _targets;
    private String _cannotAddPrompt = MultiLanguageUtil.getMLS("clipboard.R1Clipboard.cantAddPrompt", "");

    @Override
    public void setCore(ComboPanel core) {
        this._core = core;
    }

    protected ReportSelectionModel cloneModel(ReportSelectionModel sm) {
        try {
            Element xmlDom = this._core.createXmlWriter().selectionToXml(sm);
            return this._core.createXmlReader().selectionFromXml(xmlDom);
        }
        catch (Exception e) {
            log.error((Object)"\u9009\u4e2d\u6a21\u590d\u5236\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isCanCut() {
        return this.isCanCopy();
    }

    @Override
    public boolean cut() {
        if (!this.isCanCut()) {
            return false;
        }
        boolean result = this.copy();
        this._core.deleteSelection();
        return result;
    }

    @Override
    public boolean isCanCopy() {
        ElementPath[] paths = this._core.getSelectionModel().getAll();
        for (int i = 0; i < paths.length; ++i) {
            Object o = paths[i].getLastPathComponent();
            if (o instanceof IReportObject && !(o instanceof IR1Page)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean copy() {
        if (!this.isCanCopy()) {
            return false;
        }
        this._targets = this.cloneModel(this._core.getSelectionModel());
        return this._targets != null;
    }

    @Override
    public boolean isCanPaste() {
        if (this._targets == null || this._targets.size() == 0) {
            return false;
        }
        Object currentEle = this._core.getSelectionModel().getCurrent().getLastPathComponent();
        return currentEle instanceof IContainer;
    }

    @Override
    public boolean paste() {
        if (!this.isCanPaste()) {
            return false;
        }
        ElementPath currentSelected = this._core.getSelectionModel().getCurrent();
        IReportObject currentObj = (IReportObject)currentSelected.getRootPathComponent();
        IContainer currentContainer = (IContainer)currentSelected.getLastPathComponent();
        ICompositeContainer currentCompositeContainer = currentObj instanceof ICompositeContainer ? (ICompositeContainer)((Object)currentObj) : null;
        ReportSelectionModel sm = this.cloneModel(this._targets);
        ElementPath[] eps = sm.getAll();
        boolean isBoundOutside = false;
        StringBuffer sbPrompt = new StringBuffer();
        int c = eps.length;
        for (int i = 0; i < c; ++i) {
            IElement ele = (IElement)eps[i].getLastPathComponent();
            if (!(ele instanceof IReportObject)) continue;
            IReportObject ro = (IReportObject)ele;
            String cannotAddPrompt = this.checkCanAddChild(currentSelected, ro, null);
            if (cannotAddPrompt != null) {
                if (sbPrompt.length() > 0) {
                    sbPrompt.append("\uff1b");
                }
                sbPrompt.append(ele.getTypePrompt());
                sbPrompt.append("(");
                sbPrompt.append(ele.getId());
                sbPrompt.append(")");
                sbPrompt.append(MultiLanguageUtil.getMLS("clipboard.R1Clipboard.reason", ""));
                sbPrompt.append(cannotAddPrompt);
            }
            if (sbPrompt.length() != 0 || isBoundOutside) continue;
            isBoundOutside = this.isBoundOutside(currentCompositeContainer, currentContainer, ro);
        }
        if (sbPrompt.length() > 0) {
            sbPrompt.insert(0, StringUtil.RETURN);
            sbPrompt.insert(0, MultiLanguageUtil.getMLS("clipboard.R1Clipboard.cantPaste", ""));
            sbPrompt.append("\u3002");
            WindowUtil.msgboxWarning((Object)sbPrompt.toString(), (String)this._core.getPromptTitle(), (Component)this._core.getPanel());
            return false;
        }
        boolean isKeepSize = true;
        if (isBoundOutside) {
            isKeepSize = WindowUtil.msgboxYesNo((Component)this._core.getPanel(), (Object)MultiLanguageUtil.getMLS("clipboard.R1Clipboard.yesNo", ""), (String)this._core.getPromptTitle());
        }
        ArrayList<ElementPath> epsToSelect = new ArrayList<ElementPath>();
        int c2 = eps.length;
        for (int i = 0; i < c2; ++i) {
            IElement ele = (IElement)eps[i].getLastPathComponent();
            if (!(ele instanceof IReportObject)) continue;
            IReportObject ro = (IReportObject)ele;
            if (this.checkCanAddChild(currentSelected, ro, null) != null) break;
            if (!isKeepSize && this.isBoundOutside(currentCompositeContainer, currentContainer, ro)) {
                ro.setXLom(0);
                int w = this.getContainerWidthLom(currentCompositeContainer, currentContainer);
                if (ro.getWidthLom() > w) {
                    ro.setWidthLom(w);
                }
                ro.setYLom(0);
                int h = this.getContainerHeightLom(currentCompositeContainer, currentContainer);
                if (ro.getHeightLom() > h) {
                    ro.setHeightLom(h);
                }
            }
            String p = currentContainer.getLayoutParm(null);
            this._core.getModel().addReportObject(currentCompositeContainer, currentContainer, ro, p);
            ContainerUtil.layoutChildren(currentObj);
            epsToSelect.add(new ElementPath(ro));
        }
        if (epsToSelect.size() > 0) {
            this._core.getModel().updateFieldInfo();
            this._core.setSelection(epsToSelect.toArray(new ElementPath[0]));
            this._core.getPageContainer().repaint();
            return true;
        }
        return false;
    }

    protected int getContainerWidthLom(ICompositeContainer cc, IContainer c) {
        return cc == null ? c.getInsetsWidthLom() : cc.getSubContainerInsetsWidthLom(c);
    }

    protected int getContainerHeightLom(ICompositeContainer cc, IContainer c) {
        return cc == null ? c.getInsetsHeightLom() : cc.getSubContainerInsetsHeightLom(c);
    }

    protected boolean isBoundOutside(ICompositeContainer cc, IContainer c, IReportObject ro) {
        IRequestFill rf;
        if (c instanceof IRequestFill && (rf = (IRequestFill)((Object)c)).isInitHFill() && !rf.isHFillEditable() && rf.isInitVFill() && !rf.isVFillEditable()) {
            return false;
        }
        if (!ro.isHorizontalFill()) {
            int parentW = this.getContainerWidthLom(cc, c);
            if (ro.getXLom() + ro.getWidthLom() > parentW) {
                return true;
            }
        }
        if (!ro.isVerticalFill()) {
            int parentH = this.getContainerHeightLom(cc, c);
            if (ro.getYLom() + ro.getHeightLom() > parentH) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String checkCanAddChild(ElementPath parent, IReportObject child, Point mousePoint) {
        IElement ele = (IElement)parent.getLastPathComponent();
        if (ele instanceof IContainer) {
            if (((IContainer)((Object)ele)).isCanAddChild(mousePoint)) {
                return null;
            }
            return this._cannotAddPrompt;
        }
        return null;
    }
}

