/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.IGroupPrompt;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IScroll;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.datagrid.GroupPromptRender;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.SelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.util.backport.Collections;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JPanel;

public class PageContainer
extends JPanel {
    private ComboPanel comboPanel;
    private Point _paperPosition = new Point(10, 10);
    private Point _pagePosition = new Point(10, 10);
    private Point _pageBlank = new Point(20, 20);
    private IR1Page _currentPage;
    private ReportSelectionModel _selectionModel;
    private SelectionRenderer _selectionRenderer;
    private ResizeHandler _resizeHandler = new ResizeHandler();
    private GroupPromptRender _groupPromptRender;
    private CellRendererPane _cellRendererPane;
    private IExtendedRenderer _extendedRenderer;
    private IR1DataManager _dataManager;

    public PageContainer(ComboPanel comboPanel) {
        this.comboPanel = comboPanel;
        this.setLayout(null);
        this.setFocusable(true);
        this._selectionModel = new ReportSelectionModel();
        this._selectionRenderer = new SelectionRenderer();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PageContainer.this.requestFocus();
            }
        });
    }

    public ReportSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    private SelectionRenderer getSelectionRenderer() {
        return this._selectionRenderer;
    }

    public Point getPointAtPage(Point pointAtContainer) {
        Point pt = new Point(pointAtContainer);
        pt.translate(-this.getPagePos().x, -this.getPagePos().y);
        return pt;
    }

    public Point getPointAtPage(MouseEvent evt) {
        return this.getPointAtPage(evt.getPoint());
    }

    public void translate(Point ptAtPage) {
        ptAtPage.translate(this.getPagePos().x, this.getPagePos().y);
    }

    public void translate(Rectangle rectAtPage) {
        rectAtPage.translate(this.getPagePos().x, this.getPagePos().y);
    }

    public Point getPaperPos() {
        return this._paperPosition;
    }

    public Point getPagePos() {
        return this._pagePosition;
    }

    public Point getPageBlank() {
        return this._pageBlank;
    }

    public void setCurrentPage(IR1Page page) {
        if (this._currentPage != null) {
            this._currentPage.removePropertyChangeListener(this._resizeHandler);
        }
        this._currentPage = page;
        this.resize();
        this._currentPage.addPropertyChangeListener(this._resizeHandler);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._currentPage == null) {
            return;
        }
        R1PrintInfo printInfo = (R1PrintInfo)this._currentPage.getExtendProperty("pi");
        if (printInfo != null) {
            this._pagePosition = new Point(this._paperPosition.x + Util.lom2Pixel(printInfo.getMarginLeft()), this._paperPosition.y + Util.lom2Pixel(printInfo.getMarginTop()));
        }
        g = g.create();
        ((Graphics2D)g).scale(this.comboPanel.getScale(), this.comboPanel.getScale());
        Graphics g4Page = g.create();
        g4Page.translate(this.getPagePos().x, this.getPagePos().y);
        this._currentPage.getRenderer().draw(g4Page, this);
        if (this._extendedRenderer != null) {
            this._extendedRenderer.drawUnderPage(g);
        }
        Rectangle clip = new Rectangle(this._currentPage.getInsetsXLom(), this._currentPage.getInsetsYLom(), this._currentPage.getInsetsWidthLom(), this._currentPage.getInsetsHeightLom());
        Util.lom2Pixel(clip);
        this.drawObjects(this._currentPage, g4Page, clip);
        if (this._extendedRenderer != null) {
            this._extendedRenderer.drawUponPage(g);
        }
        this.drawDataGridPrompt(g);
        this.drawSelection(g4Page);
        ((Graphics2D)g).scale(1.0 / this.comboPanel.getScale(), 1.0 / this.comboPanel.getScale());
        this.paintChildren(g);
        this.getCellRendererPane().removeAll();
    }

    private CellRendererPane getCellRendererPane() {
        if (this._cellRendererPane == null) {
            this._cellRendererPane = new CellRendererPane();
        }
        if (this._cellRendererPane.getParent() != this) {
            this.add(this._cellRendererPane);
        }
        return this._cellRendererPane;
    }

    public void paintCtrl(Graphics g, Component c, Rectangle rect) {
        this.getCellRendererPane().paintComponent(g, c, this, rect.x, rect.y, rect.width, rect.height, true);
    }

    private void drawDataGridPrompt(Graphics g) {
        if (!this.getSelectionModel().hasSelected()) {
            return;
        }
        ElementPath elementPath = this.getSelectionModel().getCurrent();
        Object obj = elementPath.getRootPathComponent();
        if (obj instanceof AbstractDataGrid && obj instanceof IGroupPrompt) {
            AbstractDataGrid grid = (AbstractDataGrid)obj;
            Rectangle thisVisibleRect = this.getVisibleRect();
            if (this._groupPromptRender == null) {
                this._groupPromptRender = new GroupPromptRender();
            }
            this._groupPromptRender.setDataManager(this._dataManager);
            this._groupPromptRender.draw(g, grid, this._pagePosition.x, this._pagePosition.y, thisVisibleRect);
            if (!this._groupPromptRender.isLeft()) {
                Point gridAtPage = ContainerUtil.getPointAtPage(grid);
                int gridX = gridAtPage.x + this.getPagePos().x;
                int gridRight = gridX + grid.getWidth();
                int outPageWidth = this._groupPromptRender.getPropmtWidth() + gridRight - Util.lom2Pixel(this._currentPage.getWidthLom());
                if (outPageWidth > this._pageBlank.x) {
                    this._pageBlank.x = outPageWidth + 10;
                    this.resize();
                }
            }
        }
    }

    private void drawSelection(Graphics g) {
        for (int i = this.getSelectionModel().size() - 1; i >= 0; --i) {
            this.getSelectionRenderer().drawSelected(g, this.getSelectionModel().get(i), i == 0);
        }
    }

    private void drawObjects(IContainer container, Graphics g, Rectangle offsetAndclip) {
        if (container.getChildrenCount() == 0) {
            return;
        }
        g = g.create();
        g.translate(offsetAndclip.x, offsetAndclip.y);
        g.clipRect(0, 0, offsetAndclip.width + 3, offsetAndclip.height + 3);
        List children = container.getChildren();
        Collections.sort((List)children, (Comparator)new Comparator(){

            public int compare(Object a2, Object b) {
                if (a2 instanceof IReportObject && b instanceof IReportObject) {
                    IReportObject aro = (IReportObject)a2;
                    IReportObject bro = (IReportObject)b;
                    return aro.getZIndex() - bro.getZIndex();
                }
                return 0;
            }
        });
        for (IReportObject ro : children) {
            ro.getRenderer().draw(g, this);
            if (ro instanceof IScroll) {
                IScroll s = (IScroll)((Object)ro);
                this.addScrollBar(s.getHScrollBar());
                this.addScrollBar(s.getVScrollBar());
            }
            Point pt = new Point(ro.getXLom(), ro.getYLom());
            if (ro instanceof ICompositeContainer) {
                ICompositeContainer cc = (ICompositeContainer)((Object)ro);
                IContainer[] subContainers = cc.getSubContainers();
                for (int i = 0; i < subContainers.length; ++i) {
                    IContainer c = subContainers[i];
                    Point ptTemp = new Point(c.getInsetsXLom(), c.getInsetsYLom());
                    ptTemp.translate(pt.x, pt.y);
                    Util.lom2Pixel(ptTemp);
                    Rectangle rectTemp = cc.getSubElementRectangle((IElement)((Object)c));
                    rectTemp.translate(ptTemp.x, ptTemp.y);
                    rectTemp.width = Util.lom2Pixel(cc.getSubContainerInsetsWidthLom(c));
                    rectTemp.height = Util.lom2Pixel(cc.getSubContainerInsetsHeightLom(c));
                    this.drawObjects(c, g, rectTemp);
                }
                continue;
            }
            if (!(ro instanceof IContainer)) continue;
            IContainer c = (IContainer)((Object)ro);
            Rectangle rectTemp = new Rectangle(pt.x + c.getInsetsXLom(), pt.y + c.getInsetsYLom(), c.getInsetsWidthLom(), c.getInsetsHeightLom());
            Util.lom2Pixel(rectTemp);
            this.drawObjects(c, g, rectTemp);
        }
    }

    private void addScrollBar(IScroll.IScrollBar sb) {
        if (sb != null) {
            this.add((Component)sb.getCtrl());
            Rectangle rect = sb.getCtrlRectangle();
            rect.translate(this.getPagePos().x, this.getPagePos().y);
            sb.getCtrl().setBounds(rect);
            this.validate();
        }
    }

    public ElementPath searchTopElementWidthExt(Point pointAtContainer, int extOutsideObj) {
        Point ptAtPage = this.getPointAtPage(pointAtContainer);
        if (this._currentPage == null || !this._currentPage.isPointInside(ptAtPage, extOutsideObj)) {
            return null;
        }
        ElementPath elePath = this.searchTopElement(this._currentPage, ptAtPage, extOutsideObj);
        return elePath == null ? new ElementPath(this._currentPage) : elePath;
    }

    public ElementPath searchTopElement(Point pointAtContainer) {
        return this.searchTopElementWidthExt(pointAtContainer, 0);
    }

    private ElementPath searchTopElement(IContainer container, Point pointAtPage, int extOutsideObj) {
        if (container.getChildrenCount() == 0) {
            return null;
        }
        for (IReportObject ro : container.getChildren()) {
            if (!ro.isPointInside(pointAtPage, extOutsideObj)) continue;
            ElementPath result = null;
            if (ro instanceof IContainer) {
                result = this.searchTopElement((IContainer)((Object)ro), pointAtPage, extOutsideObj);
                return result == null ? new ElementPath(ro) : result;
            }
            if (ro instanceof ICompositeObject) {
                IElement[] subEles = ((ICompositeObject)((Object)ro)).getViewSubElements();
                for (int i = 0; i < subEles.length; ++i) {
                    if (!((ICompositeObject)((Object)ro)).isPointInSubElement(subEles[i], pointAtPage)) continue;
                    if (subEles[i] instanceof IContainer) {
                        result = this.searchTopElement((IContainer)((Object)subEles[i]), pointAtPage, extOutsideObj);
                    }
                    return result == null ? ((ICompositeObject)((Object)ro)).makeElementPath(subEles[i]) : result;
                }
                return new ElementPath(ro);
            }
            return new ElementPath(ro);
        }
        return null;
    }

    public void resize() {
        R1PrintInfo printInfo = (R1PrintInfo)this._currentPage.getExtendProperty("pi");
        if (printInfo != null) {
            int height = Math.max(printInfo.getPrintablePaperSize().height, this._currentPage.getHeightLom() + printInfo.getMarginTop());
            double scale = this.comboPanel.getScale();
            this.setPreferredSize(new Dimension((int)Math.round((double)(Util.lom2Pixel(printInfo.getPrintablePaperSize().width) + this._pageBlank.x) * scale), (int)Math.round((double)(Util.lom2Pixel(height) + this._pageBlank.y) * scale)));
        } else {
            double scale = this.comboPanel.getScale();
            this.setPreferredSize(new Dimension((int)Math.round((double)(Util.lom2Pixel(this._currentPage.getWidthLom()) + this._pageBlank.x) * scale), (int)Math.round((double)(Util.lom2Pixel(this._currentPage.getHeightLom()) + this._pageBlank.y) * scale)));
        }
        this.revalidate();
        this.repaint();
    }

    public int getDirectionByPoint(Point ptAtContainer) {
        Point ptAtPage = this.getPointAtPage(ptAtContainer);
        int c = this.getSelectionModel().size();
        for (int i = 0; i < c; ++i) {
            ElementPath ep = this.getSelectionModel().get(i);
            Object ele = ep.getLastPathComponent();
            if (!(ele instanceof IReportObject)) continue;
            IReportObject ro = (IReportObject)ele;
            if (ro.isLocked()) {
                return -1;
            }
            int dir = SelectionRenderer.getDirectionByPoint(ro, ptAtPage);
            if (ele instanceof IR1Page) {
                if (dir != 1 && dir != 4 && dir != 5) {
                    dir = -1;
                }
            } else {
                boolean isHUnresizable = !ro.isHorizontalResizable();
                boolean isVUnresizable = !ro.isVerticalResizable();
                boolean isHFill = ro.isHorizontalFill();
                boolean isVFill = ro.isVerticalFill();
                switch (dir) {
                    case 10: {
                        return isHFill && isVFill ? -1 : dir;
                    }
                    case 4: 
                    case 8: {
                        return isVFill || isVUnresizable ? -1 : dir;
                    }
                    case 1: 
                    case 2: {
                        return isHFill || isHUnresizable ? -1 : dir;
                    }
                }
                return isVUnresizable || isVFill || isHFill || isHUnresizable ? -1 : dir;
            }
            return dir;
        }
        return -1;
    }

    public Graphics getGraphicsOfPage() {
        Graphics g = this.getGraphics();
        g = g.create();
        ((Graphics2D)g).scale(this.comboPanel.getScale(), this.comboPanel.getScale());
        g.translate(this.getPagePos().x, this.getPagePos().y);
        return g;
    }

    public void setExtendedRenderer(IExtendedRenderer er) {
        this._extendedRenderer = er;
    }

    void setDataManager(IR1DataManager dataManager) {
        this._dataManager = dataManager;
    }

    public static interface IExtendedRenderer {
        public void drawUnderPage(Graphics var1);

        public void drawUponPage(Graphics var1);
    }

    class ResizeHandler
    implements PropertyChangeListener {
        ResizeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("widthLom".equals(evt.getPropertyName()) || "heightLom".equals(evt.getPropertyName())) {
                PageContainer.this.resize();
            }
        }
    }
}

