/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

class GridXmlTransUtil {
    private static String STAT_SUM = "sum";
    private static String STAT_AVG = "avg";
    private static String STAT_MAX = "max";
    private static String STAT_MIN = "min";
    private static String STAT_COUNT = "count";
    private static final String GROUP_ACCORDING_FIELD = "field";
    private static final String GROUP_ACCORDING_FORMULA = "formula";

    GridXmlTransUtil() {
    }

    static void loadCellValue(Element nodeCell, AbstractDataGridCell cell) {
        Element nodeValue = nodeCell.getChild("Value");
        if (nodeValue != null) {
            ICellValue cellValue = null;
            String type = nodeValue.getAttributeValue("type");
            String content = nodeValue.getTextTrim();
            if (StringUtil.equals((String)type, (String)"text")) {
                cellValue = new Text(content);
            } else if (StringUtil.equals((String)type, (String)GROUP_ACCORDING_FIELD)) {
                cellValue = CellField.create(content, null);
            } else if (StringUtil.equals((String)type, (String)"stat")) {
                cellValue = new StatField();
                Field mf = Field.valueOf(content, null);
                ((StatField)cellValue).setField(mf);
                String statType = nodeValue.getAttributeValue("stat");
                ((StatField)cellValue).setType(GridXmlTransUtil.loadStat(statType));
            }
            cell.setValue(cellValue);
        }
    }

    private static int loadStat(String statType) {
        if (StringUtil.equalsIgnoreCase((String)STAT_SUM, (String)statType)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_AVG, (String)statType)) {
            return 2;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_MAX, (String)statType)) {
            return 3;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_MIN, (String)statType)) {
            return 4;
        }
        if (StringUtil.equalsIgnoreCase((String)STAT_COUNT, (String)statType)) {
            return 5;
        }
        return 1;
    }

    static void saveCellValue(AbstractDataGridCell cell, Element nodeCell) {
        ICellValue value = cell.getValue();
        if (value != null) {
            String type;
            Element nodeValue = new Element("Value");
            String content = null;
            switch (value.getCellType()) {
                case 1: {
                    type = "text";
                    content = ((Text)value).getText();
                    break;
                }
                case 2: {
                    type = GROUP_ACCORDING_FIELD;
                    Field field = (Field)((Object)value);
                    content = field.getName();
                    break;
                }
                case 3: {
                    type = "stat";
                    Field field = ((StatField)value).getField();
                    if (field != null) {
                        content = field.getName();
                    }
                    nodeValue.setAttribute("stat", GridXmlTransUtil.saveStat((StatField)value));
                    break;
                }
                default: {
                    type = "unknown";
                }
            }
            nodeValue.setAttribute("type", type);
            nodeValue.addContent(content);
            nodeCell.addContent((Content)nodeValue);
        }
    }

    private static String saveStat(StatField designStat) {
        switch (designStat.getType()) {
            case 1: {
                return STAT_SUM;
            }
            case 2: {
                return STAT_AVG;
            }
            case 3: {
                return STAT_MAX;
            }
            case 4: {
                return STAT_MIN;
            }
            case 5: {
                return STAT_COUNT;
            }
        }
        return "unknown";
    }

    static class GroupsSaver {
        private HashMap mapGroups = new HashMap();
        private int iGroupId = 0;

        GroupsSaver() {
        }

        public void storeGroup(AbstractGroupRow row, Element nodeRow) {
            String groupId;
            R1DataGridGroup group = row.getGroup();
            if (this.mapGroups.containsKey(group)) {
                groupId = (String)this.mapGroups.get(group);
            } else {
                groupId = "g" + this.iGroupId++;
                this.mapGroups.put(group, groupId);
            }
            nodeRow.setAttribute("group", groupId);
        }

        public void saveGroups(Element nodeGrid) {
            if (this.mapGroups.size() > 0) {
                Element nodeGroups = new Element("Groups");
                for (R1DataGridGroup group : this.mapGroups.keySet()) {
                    String groupId = (String)this.mapGroups.get(group);
                    Element nodeGroup = new Element("Group");
                    nodeGroup.setAttribute("id", groupId);
                    if (group.getAccordingType() == 2) {
                        nodeGroup.setAttribute("according", GridXmlTransUtil.GROUP_ACCORDING_FORMULA);
                    } else {
                        nodeGroup.setAttribute("according", GridXmlTransUtil.GROUP_ACCORDING_FIELD);
                    }
                    nodeGroup.setText(group.getAccording());
                    nodeGroups.addContent((Content)nodeGroup);
                }
                nodeGrid.addContent((Content)nodeGroups);
            }
        }
    }

    static class MergeBlocksSaver {
        private Element nodeMergeBlocks = new Element("MergeBlocks");

        MergeBlocksSaver() {
        }

        public void saveMergeBlocks(Element nodeGrid) {
            if (this.nodeMergeBlocks.getChildren().size() > 0) {
                nodeGrid.addContent((Content)this.nodeMergeBlocks);
            }
        }

        public void storeMergeBlock(AbstractGrid grid, AbstractCell cell) {
            if (cell.getMergeBlock() != null) {
                MergeBlock mb = cell.getMergeBlock();
                Point pt = grid.getIndexOfCell(cell);
                if (mb.isFirstCell(pt.x, pt.y)) {
                    Element nodeBlock = new Element("Block");
                    nodeBlock.setAttribute("left", String.valueOf(mb.getLeft()));
                    nodeBlock.setAttribute("right", String.valueOf(mb.getRight()));
                    nodeBlock.setAttribute("top", String.valueOf(mb.getTop()));
                    nodeBlock.setAttribute("bottom", String.valueOf(mb.getBottom()));
                    this.nodeMergeBlocks.addContent((Content)nodeBlock);
                }
            }
        }
    }

    static class GroupsLoader {
        private HashMap mapGroups = new HashMap();

        GroupsLoader() {
        }

        public void loadGroups(Element nodeGrid) {
            Element nodeGroups = nodeGrid.getChild("Groups");
            if (nodeGroups == null) {
                return;
            }
            List list = nodeGroups.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                Element nodeGroup = (Element)list.get(i);
                String groupId = nodeGroup.getAttributeValue("id");
                R1DataGridGroup group = new R1DataGridGroup(nodeGroup.getText());
                if (GridXmlTransUtil.GROUP_ACCORDING_FORMULA.equals(nodeGroup.getAttributeValue("according"))) {
                    group.setAccordingType(2);
                } else {
                    group.setAccordingType(1);
                }
                this.mapGroups.put(groupId, group);
            }
        }

        public void supplyGroup(Element nodeRow, AbstractGroupRow row) {
            String id = nodeRow.getAttributeValue("group");
            R1DataGridGroup group = (R1DataGridGroup)this.mapGroups.get(id);
            row.setGroup(group);
        }
    }

    static class MergeBlocksLoader {
        MergeBlocksLoader() {
        }

        static void loadMergeBlock(Element nodeGrid, AbstractGrid grid) {
            Element nodeMergeBlocks = nodeGrid.getChild("MergeBlocks");
            if (nodeMergeBlocks != null) {
                for (Element nodeBlock : nodeMergeBlocks.getChildren("Block")) {
                    int left = Integer.parseInt(nodeBlock.getAttributeValue("left"));
                    int right = Integer.parseInt(nodeBlock.getAttributeValue("right"));
                    int top = Integer.parseInt(nodeBlock.getAttributeValue("top"));
                    int bottom = Integer.parseInt(nodeBlock.getAttributeValue("bottom"));
                    MergeBlock mb = MergeBlock.create(left, right, top, bottom);
                    for (int i = top; i <= bottom; ++i) {
                        for (int j = left; j <= right; ++j) {
                            AbstractCell cell = grid.getCell(i, j);
                            cell.setMergeBlock(mb);
                        }
                    }
                }
            }
        }
    }
}

