/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.form.export;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.AtoCUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.AExportContext;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.INode;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.IModelManager;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.IViewEventListener;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.model.Binding;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.widget.AWidget;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class R1FormWidgetExportContext
extends AExportContext {
    private IModelManager modelManager;
    private IViewEventListener eventHandler;

    public R1FormWidgetExportContext() throws ExportException {
        super("com/kingdee/bos/ctrl/reportone/r1/form/engine/form/export/ExporterFactory.xml");
    }

    public final IModelManager getModelManager() {
        return this.modelManager;
    }

    public final void setModelManager(IModelManager model) {
        this.modelManager = model;
    }

    public final IViewEventListener getEventHandler() {
        return this.eventHandler;
    }

    public final void setEventHandler(IViewEventListener eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public Object exportNode(INode node) throws ExportException {
        Object out = super.exportNode(node);
        this.afterExportNode(node, out);
        return out;
    }

    private void afterExportNode(INode node, Object out) {
        JViewport viewPort;
        AWidget wgt = (AWidget)node;
        ASwingView view = (ASwingView)out;
        view.setName(node.getName());
        view.setType(node.getType());
        Binding binding = wgt.getBinding();
        if (binding != null) {
            AModel model = this.modelManager.getModel(binding.getTableName());
            view.setModel(model);
        }
        view.setBinding(binding);
        view.setEventHandler(this.eventHandler);
        view.setStyle(wgt.getStyle());
        view.setUserObject(wgt.getUserObject());
        JComponent comp = view.getComponent();
        boolean setChild = false;
        if (comp instanceof JScrollPane && (viewPort = ((JScrollPane)comp).getViewport()).getComponentCount() > 0 && viewPort.getComponent(0) instanceof JList) {
            viewPort.getComponent(0).setName(node.getName());
            setChild = true;
        }
        if (!setChild) {
            comp.setName(node.getName());
        }
        Dimension prefSize = comp.getPreferredSize();
        if (wgt.getWidth() != -1) {
            prefSize.width = wgt.getWidth();
        }
        if (wgt.getHeight() != -1) {
            prefSize.height = wgt.getHeight();
        }
        comp.setPreferredSize(prefSize);
        comp.setBounds(wgt.getLeft(), wgt.getTop(), wgt.getWidth(), wgt.getHeight());
        Style style = ((IReportObject)wgt.getUserObject()).getStyle();
        if (style != null) {
            AtoCUtil.passComponent(comp, style);
        }
    }
}

