/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.reportone.r1.print.barcode.EAN128Util;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.CodabarEncoder;
import org.jbarcode.encode.Code11Encoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.Code39ExtEncoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.Code93ExtEncoder;
import org.jbarcode.encode.EAN8Encoder;
import org.jbarcode.encode.Interleaved2of5Encoder;
import org.jbarcode.encode.InvalidAtributeException;
import org.jbarcode.encode.MSIPlesseyEncoder;
import org.jbarcode.encode.PostNetEncoder;
import org.jbarcode.encode.Standard2of5Encoder;
import org.jbarcode.encode.UPCAEncoder;
import org.jbarcode.encode.UPCEEncoder;
import org.jbarcode.paint.BaseLineTextPainter;
import org.jbarcode.paint.EAN8TextPainter;
import org.jbarcode.paint.HeightCodedPainter;
import org.jbarcode.paint.UPCATextPainter;
import org.jbarcode.paint.UPCETextPainter;
import org.jbarcode.paint.WideRatioCodedPainter;
import org.jbarcode.paint.WidthCodedPainter;
import org.jbarcode.util.ImageUtil;

public class BarCodeGeneraterUtil {
    private static String CODE128 = "code128";
    private static String EAN128 = "ean-128";
    private static String CODE39 = "code39";
    private static String CODE11 = "code11";
    private static String CODE39EXT = "code39-ext";
    private static String CODE93 = "code93";
    private static String CODE93EXT = "code93-ext";
    private static String EAN13 = "ean-13";
    private static String EAN8 = "ean-8";
    private static String CODABAR = "codabar";
    private static String Interleaved2of5 = "intl2of5";
    private static String MSI = "msi";
    private static String POSTNET = "postnet";
    private static String Standard2of5 = "standard2of5";
    private static String UPCA = "upc-a";
    private static String UPCE = "upc-e";

    public static byte[] generateBarcodePicture(String barcode, String type, Map config) throws InvalidAtributeException, IOException {
        double height;
        double modelWidth;
        if (type == null || "".equals(type)) {
            type = CODE128;
        }
        JBarcode localJBarcode = null;
        if (type.equals(CODE128)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Code128Encoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
            localJBarcode.setCheckDigit(false);
            localJBarcode.setShowCheckDigit(false);
        } else {
            if (type.equals(EAN128)) {
                return EAN128Util.generate(barcode, EAN128, config);
            }
            if (type.equals(CODE39)) {
                localJBarcode = new JBarcode(Code39Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                localJBarcode.setCheckDigit(false);
                localJBarcode.setShowCheckDigit(false);
            } else if (type.equals(CODE39EXT)) {
                localJBarcode = new JBarcode(Code39ExtEncoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                localJBarcode.setCheckDigit(false);
                localJBarcode.setShowCheckDigit(false);
            } else if (type.equals(CODE93)) {
                localJBarcode = new JBarcode(Code93Encoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                localJBarcode.setCheckDigit(true);
                localJBarcode.setShowCheckDigit(false);
            } else if (type.equals(CODE93EXT)) {
                localJBarcode = new JBarcode(Code93ExtEncoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                localJBarcode.setCheckDigit(true);
                localJBarcode.setShowCheckDigit(false);
            } else if (type.equals(CODE11)) {
                localJBarcode = new JBarcode(Code11Encoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                localJBarcode.setShowText(true);
                localJBarcode.setCheckDigit(true);
                localJBarcode.setShowCheckDigit(true);
            } else {
                if (type.equals(EAN13)) {
                    return EAN128Util.generate(barcode, type, config);
                }
                if (type.equals(EAN8)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)EAN8Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN8TextPainter.getInstance());
                } else if (type.equals(CODABAR)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)CodabarEncoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                } else if (type.equals(Interleaved2of5)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)Interleaved2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                } else if (type.equals(MSI)) {
                    localJBarcode = new JBarcode(MSIPlesseyEncoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                } else if (type.equals(POSTNET)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)PostNetEncoder.getInstance(), HeightCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                } else if (type.equals(Standard2of5)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)Standard2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
                } else if (type.equals(UPCA)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)UPCAEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCATextPainter.getInstance());
                } else if (type.equals(UPCE)) {
                    localJBarcode = new JBarcode((BarcodeEncoder)UPCEEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCETextPainter.getInstance());
                }
            }
        }
        if (config.get("modelWidth") != null && !"".equals(config.get("modelWidth").toString().trim()) && (modelWidth = Double.parseDouble(config.get("modelWidth").toString())) != 0.0) {
            localJBarcode.setXDimension(modelWidth);
        }
        if (config.get("height") != null && !"".equals(config.get("height").toString().trim()) && (height = Double.parseDouble(config.get("height").toString())) != 0.0) {
            localJBarcode.setBarHeight(height);
        }
        BufferedImage localBufferedImage = localJBarcode.createBarcode(barcode);
        return ImageUtil.encode((BufferedImage)localBufferedImage, (String)"jpeg");
    }
}

