/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IPropertyUnsupported;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IR1PrintScriptable;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.script.ScriptEditor;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class PanelElementCommon
extends AbstractPropertyPanel {
    public static final String NSP_NoPrint = "noprint";
    protected KDTextField _txtName;
    protected KDCheckBox _chkNoPrint;
    protected ScriptEditor _edtPreScript;
    protected ScriptEditor _edtScript;
    protected boolean _isMultiSelected;
    private ComboPanel _core;
    private IElement _currentEle;

    public PanelElementCommon() {
        this.init();
        this.addCtrl();
    }

    protected PanelElementCommon(boolean nothing) {
        this.init();
    }

    private void init() {
        this._txtName = new KDTextField();
        CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)MultiLanguageUtil.getMLS("property.PanelElementCommon.name", ""), (int)80);
        this._chkNoPrint = new KDCheckBox(MultiLanguageUtil.getMLS("property.PanelElementCommon.notPrint", ""));
        this._chkNoPrint.setSwitch(false);
        this._edtPreScript = new ScriptEditor(MultiLanguageUtil.getMLS("property.PanelElementCommon.frontScript", ""));
        this._edtScript = new ScriptEditor(MultiLanguageUtil.getMLS("property.PanelElementCommon.backScript", ""));
        this._edtPreScript.addHeavyColorInterface(ScriptSystemMethod.class);
        this._edtPreScript.addHeavyColorInterface(IR1PrintScriptable.class);
        this._edtScript.addHeavyColorInterface(ScriptSystemMethod.class);
        this._edtScript.addHeavyColorInterface(IR1PrintScriptable.class);
    }

    private void addCtrl() {
        TableLayout lyScript = TableLayout.splitRow((int)2);
        lyScript.getStyle().setMargin(8, 16, 8, 8);
        lyScript.rowStyle(0).setHeight(-50);
        lyScript.rowStyle(1).setHeight(-50);
        KDPanel panelScript = new KDPanel((LayoutManager)lyScript);
        panelScript.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("property.PanelElementCommon.script", "")));
        panelScript.add((Component)this._edtPreScript.getUI(), (Object)lyScript.cell(0));
        panelScript.add((Component)this._edtScript.getUI(), (Object)lyScript.cell(1));
        TableLayout tl = TableLayout.splitRow((int)3);
        tl.defaultStyle().setMarginBottom(6);
        tl.style().setMargin(8);
        tl.rowStyle(2).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this._txtName.getLabelContainer(), tl.cell(0));
        this.add((Component)this._chkNoPrint, tl.cell(1));
        this.add((Component)panelScript, tl.cell(2));
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("property.PanelElementCommon.allUse", "");
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eps) {
        this._core = core;
        this._currentEle = (IElement)eps[0].getLastPathComponent();
        this._edtScript.setDataManager(this._core.getModel().getDataManager());
        this._edtPreScript.setDataManager(this._core.getModel().getDataManager());
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        IElement ele = (IElement)eps[0].getLastPathComponent();
        if (eps.length > 1) {
            this._isMultiSelected = true;
            this._txtName.setEnabled(false);
            this._txtName.setText(null);
        } else {
            this._isMultiSelected = false;
            this._txtName.setEnabled(true);
            this._txtName.setText(ele.getId());
        }
        boolean isHide = ele.isHide();
        boolean isHideUnsure = false;
        boolean isHideUnsupported = PanelElementCommon.isUnsupported(ele, NSP_NoPrint);
        String script = ele.getScript();
        boolean isScriptUnsure = false;
        String preScript = ele.getPreScript();
        boolean isPreScriptUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            ele = (IElement)eps[i].getLastPathComponent();
            if (!isHideUnsupported) {
                isHideUnsupported = PanelElementCommon.isUnsupported(ele, NSP_NoPrint);
                if (!isHideUnsure && isHide != ele.isHide()) {
                    isHideUnsure = true;
                }
            }
            if (!isScriptUnsure && !StringUtil.equals((String)script, (String)ele.getScript())) {
                isScriptUnsure = true;
            }
            if (isPreScriptUnsure || StringUtil.equals((String)preScript, (String)ele.getPreScript())) continue;
            isPreScriptUnsure = true;
        }
        if (isHideUnsupported) {
            this._chkNoPrint.setVisible(false);
            this._chkNoPrint.setSelected(false);
        } else {
            this._chkNoPrint.setVisible(true);
            if (isHideUnsure) {
                this._chkNoPrint.setSelectState(64);
            } else {
                this._chkNoPrint.setSelected(isHide);
            }
        }
        if (isScriptUnsure) {
            this._edtScript.setText(null);
        } else {
            this._edtScript.setText(script);
        }
        if (isPreScriptUnsure) {
            this._edtPreScript.setText(null);
        } else {
            this._edtPreScript.setText(preScript);
        }
        this._edtPreScript.clearEditedMark();
        this._edtScript.clearEditedMark();
    }

    private static boolean isUnsupported(IElement ele, String key) {
        if (ele instanceof IPropertyUnsupported) {
            List keys = ((IPropertyUnsupported)((Object)ele)).getUnsupportedPropertyKeys();
            return keys.contains(key);
        }
        return false;
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        String newId;
        String oldId;
        IElement ele = (IElement)elePath.getLastPathComponent();
        if (!this._isMultiSelected && !StringUtil.equalsIgnoreCase((String)(oldId = ele.getId()), (String)(newId = this._txtName.getText()))) {
            ele.setId(newId);
            this._core.getModel().fireRenameEvent(elePath, oldId, newId);
        }
        if (this._chkNoPrint.isVisible() && this._chkNoPrint.getSelectState() != 64) {
            ele.setHide(this._chkNoPrint.isSelected());
        }
        if (this._edtScript.isEdited()) {
            ele.setScript(this._edtScript.getText());
        }
        if (this._edtPreScript.isEdited()) {
            ele.setPreScript(this._edtPreScript.getText());
        }
    }

    @Override
    public boolean verify() {
        if (this._isMultiSelected) {
            return true;
        }
        String newId = this._txtName.getText();
        if (PanelElementCommon.isInvalidString(newId)) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("property.PanelElementCommon.nameRule", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        List existIds = this._core.getModel().getExistIds(this._currentEle);
        if (existIds.contains(newId)) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("property.PanelElementCommon.nameReInput", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (StringUtil.isEmptyString((String)newId)) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("property.PanelElementCommon.noNullName", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    private static boolean isInvalidString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (!(chr < '0' || chr > '9' && chr < 'A' || chr > 'Z' && chr < '_' || chr == '`') && chr <= 'z') continue;
            return true;
        }
        return false;
    }
}

