/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataGridUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class R1PrintModelHelper {
    public static final String Key_PrintInfo = "pi";
    public static final String Key_HeadFooter = "headFooterOfLongPageMode";
    public static final String Key_Data_Sort = "dataExtend_sorts";

    public static R1PrintInfo getPrintInfo(ReportModel model) {
        Object obj = model.getPage().getExtendProperty(Key_PrintInfo);
        if (obj == null) {
            obj = new R1PrintInfo();
            model.getPage().setExtendProperty(Key_PrintInfo, obj);
        }
        return (R1PrintInfo)obj;
    }

    public static void setPrintInfo(ReportModel model, R1PrintInfo info) {
        model.getPage().setExtendProperty(Key_PrintInfo, info);
    }

    public static LongPageModeHeadFooterModel getHeadFooterOfLongPageMode(IR1Page page) {
        return (LongPageModeHeadFooterModel)page.getExtendProperty(Key_HeadFooter);
    }

    public static void setHeadFooterOfLongPageMode(IR1Page page, LongPageModeHeadFooterModel hfm) {
        page.setExtendProperty(Key_HeadFooter, hfm);
    }

    public static List getDataSorts(DataExtend ext) {
        ArrayList result = (ArrayList)ext.getProperty(Key_Data_Sort);
        if (result == null) {
            result = new ArrayList();
            ext.setProperty(Key_Data_Sort, result);
        }
        return result;
    }

    public static void pickSort(ReportModel model) {
        model.scanContainer(model.getPage(), new ScanGroup2Sort(model.getDataManager()), false);
    }

    private static class ScanGroup2Sort
    implements ReportModel.IScanModel {
        private IR1DataManager dm;

        public ScanGroup2Sort(IR1DataManager dataManager) {
            this.dm = dataManager;
        }

        @Override
        public void doSthWithElement(IElement ele) {
            if (!(ele instanceof DataGrid)) {
                return;
            }
            DataGrid grid = (DataGrid)ele;
            R1DataGridGroup[] groups = DataGridUtil.getGroups(grid);
            DataExtend ext = this.dm.getDataExtend(grid.getDataSource().getDs());
            if (groups.length == 0 || ext == null) {
                return;
            }
            ArrayList<SystemR1PrintDataSortItem> newSysItems = new ArrayList<SystemR1PrintDataSortItem>();
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i].getAccordingType() != 1) continue;
                SystemR1PrintDataSortItem sortItem = new SystemR1PrintDataSortItem();
                sortItem.setSystem(true);
                sortItem.setSortType(0);
                sortItem.setSortField(groups[i].getAccording());
                newSysItems.add(sortItem);
            }
            List sorts = R1PrintModelHelper.getDataSorts(ext);
            Iterator it = sorts.iterator();
            while (it.hasNext()) {
                SystemR1PrintDataSortItem sortItem = (SystemR1PrintDataSortItem)it.next();
                boolean exist = false;
                int c = newSysItems.size();
                for (int i = 0; i < c; ++i) {
                    SystemR1PrintDataSortItem newSysItem = (SystemR1PrintDataSortItem)newSysItems.get(i);
                    if (!StringUtil.equals((String)newSysItem.getSortField(), (String)sortItem.getSortField())) continue;
                    newSysItem.setSortType(sortItem.getSortType());
                    exist = true;
                    break;
                }
                if (!sortItem.isSystem() && !exist) continue;
                it.remove();
            }
            for (int i = newSysItems.size() - 1; i >= 0; --i) {
                sorts.add(0, newSysItems.get(i));
            }
        }

        @Override
        public IElement getExceptElement() {
            return null;
        }
    }
}

