/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportframework.design;

import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.MetaClassSelectNode;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesignListener;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportframework.design.ReportDesignEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.event.EventListenerList;

public abstract class AReportDesigner
implements IReportDesigner {
    protected final Dimension DEFAULT_WINDOW_SIZE = new Dimension(792, 566);
    protected Component owner;
    private IReportEnv rptEnv;
    private EventListenerList evtList;

    public AReportDesigner(Component owner) {
        this.owner = owner;
    }

    @Override
    public Component getComponent() throws ReportException {
        return null;
    }

    @Override
    public void close() throws ReportException {
    }

    @Override
    public IReportEnv getReportEnv() {
        return this.rptEnv;
    }

    @Override
    public void setReportEnv(IReportEnv rptEnv) {
        this.rptEnv = rptEnv;
    }

    protected EventListenerList getEventListenerList() {
        if (this.evtList == null) {
            this.evtList = new EventListenerList();
        }
        return this.evtList;
    }

    @Override
    public void addDesignListener(IReportDesignListener listener) {
        this.getEventListenerList().add(IReportDesignListener.class, listener);
    }

    @Override
    public void removeDesignListener(IReportDesignListener listener) {
        this.getEventListenerList().remove(IReportDesignListener.class, listener);
    }

    @Override
    public IReportDesignListener[] getDesignListners() {
        return (IReportDesignListener[])this.getEventListenerList().getListeners(IReportDesignListener.class);
    }

    protected void fireSaveCompleted() {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ReportDesignEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IReportDesignListener.class) continue;
            if (evt == null) {
                evt = new ReportDesignEvent(this);
            }
            ((IReportDesignListener)listeners[i + 1]).saveCompleted(evt);
        }
    }

    protected void fireWindowClosed() {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ReportDesignEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IReportDesignListener.class) continue;
            if (evt == null) {
                evt = new ReportDesignEvent(this);
            }
            ((IReportDesignListener)listeners[i + 1]).windowClosed(evt);
        }
    }

    protected IObjectSelector getObjectSelector(Map args) throws ReportException {
        IObjectSelector objSel = (IObjectSelector)args.get(ReportUtil.ARG_OBJECT_SELECTOR);
        if (objSel != null) {
            return objSel;
        }
        MetaClass mc = (MetaClass)args.get(ReportUtil.ARG_META_CLASS);
        if (mc != null) {
            return new MetaClassSelectNode(mc);
        }
        return ReportUtil.makeMetaClassSelectTree(this.rptEnv.getDSFactory());
    }

    protected class WindowEventHandler
    extends WindowAdapter {
        @Override
        public void windowClosed(WindowEvent e) {
            AReportDesigner.this.fireWindowClosed();
            super.windowClosed(e);
        }
    }
}

