/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportframework.execute;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.IReportExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class AbstractLocalReportExecutor
implements IReportExecutor {
    private IReportStorage storage;
    private IDataExecutor executor;
    private IBizContent bizContent;

    public IReportStorage getReportStorage() {
        return this.storage;
    }

    public void setReportStorage(IReportStorage s) {
        this.storage = s;
    }

    public IDataExecutor getDataExecutor() {
        return this.executor;
    }

    public void setDataExecutor(IDataExecutor s) {
        this.executor = s;
    }

    @Override
    public IBizContent getBizContent() {
        return this.bizContent;
    }

    @Override
    public void setBizContent(IBizContent bizContent) {
        this.bizContent = bizContent;
    }

    protected Object executeObject(FullPath fp, HashMap impArgs) throws ReportException {
        try {
            return this.getDataExecutor().execute(null, fp, impArgs, null);
        }
        catch (Exception ex) {
            throw ReportException.makeException(ex);
        }
    }

    public byte[] readTemplate() throws ReportException {
        InputStream in = null;
        try {
            IStreamStorage stream = (IStreamStorage)this.getReportStorage();
            in = stream.getInputStream();
            byte[] byArray = CtrlUtil.Stream.readInputStream((InputStream)in);
            return byArray;
        }
        catch (IOException ex) {
            throw ReportException.makeException("", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

