/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.CubeModelEditor;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.CubeModelDataProvider;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.ObjectSelector4CubeModel;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.ReportStorage_CubeModelStorage;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class CubeModelRptDesigner
extends AReportDesigner {
    private static final Logger log = LogUtil.getPackageLogger(CubeModelRptDesigner.class);
    private CubeModelEditor editor;
    private ReportStorage_CubeModelStorage cubeSto;
    private ConfigureCubeAction action_configure;

    public CubeModelRptDesigner(Component owner) {
        super(owner);
    }

    @Override
    public void design(boolean isNew, HashMap args) throws ReportException {
        if (this.editor != null) {
            throw new AlreadyOpenedException();
        }
        ObjectSelector4CubeModel mdSelector = new ObjectSelector4CubeModel(this.getObjectSelector(args));
        this.cubeSto = new ReportStorage_CubeModelStorage(this.getReportEnv().getReportStorage(), mdSelector.getObjectSelector());
        this.editor = this.makeEditor(mdSelector);
        this.cubeSto.setCmEditor(this.editor);
        this.action_configure = new ConfigureCubeAction(this.cubeSto);
        CubeModel cm = null;
        if (!isNew) {
            try {
                cm = this.cubeSto.open();
            }
            catch (Exception ex) {
                throw ReportException.makeException("", ex);
            }
        }
        if (cm != null) {
            try {
                this.editor.setCubeModel(cm);
            }
            catch (AnalysisException ex) {
                log.error((Object)ImplResource.getString("res_3"), (Throwable)ex);
                WindowUtil.msgboxError((Object)ex.getMessage(), (String)ImplResource.getString("res_3"), (Component)this.owner);
            }
        }
        Window wnd = this.makeEditWindow(this.editor, args);
        wnd.show();
    }

    private CubeModelEditor makeEditor(ObjectSelector4CubeModel mdSelector) {
        _CubeModelEditor cmEditor = new _CubeModelEditor(mdSelector, false);
        cmEditor.setStorage(this.cubeSto);
        cmEditor.setExtendAfterSaveAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelRptDesigner.this.fireSaveCompleted();
            }
        });
        cmEditor.setExtendAfterExitAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelRptDesigner.this.fireWindowClosed();
            }
        });
        return cmEditor;
    }

    private Window makeEditWindow(CubeModelEditor cmEditor, Map args) {
        KDFrame frame = new KDFrame();
        Object uiTitle = args.get(ReportUtil.ARG_UI_TITLE);
        frame.setTitle(uiTitle != null ? (String)uiTitle : ImplResource.getString("res_4"));
        frame.getContentPane().add((Component)cmEditor);
        frame.setSize(800, 600);
        frame.setExtendedState(6);
        frame.setLocationRelativeTo(null);
        if (cmEditor.getToolBar() != null) {
            frame.addToolBar((JToolBar)cmEditor.getToolBar());
        }
        if (cmEditor.getMenuBar() != null) {
            frame.setJMenuBar((JMenuBar)cmEditor.getMenuBar());
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CubeModelRptDesigner.this.editor.exit();
            }
        });
        cmEditor.setWindow((Window)frame);
        return frame;
    }

    @Override
    public void close() throws ReportException {
        this.editor = null;
    }

    @Override
    public Component getComponent() throws ReportException {
        return this.editor;
    }

    public class ConfigureCubeAction
    extends AbstractAction {
        private ReportStorage_CubeModelStorage cubeSto;

        ConfigureCubeAction(ReportStorage_CubeModelStorage cubeSto) {
            super(ImplResource.getString("res_5"));
            this.cubeSto = cubeSto;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cubeSto.temporarilySave(CubeModelRptDesigner.this.editor.getActionHelper().parseCubeModel());
        }
    }

    public class _CubeModelEditor
    extends CubeModelEditor {
        public _CubeModelEditor(CubeModelDataProvider dataProvider, boolean showOpen) {
            super(dataProvider, showOpen);
        }

        public KDMenuBar getMenuBar() {
            KDMenuBar menuBar = super.getMenuBar();
            boolean needAdd = true;
            JMenu fileMenu = menuBar.getMenu(0);
            for (int i = 0; i < fileMenu.getItemCount(); ++i) {
                JMenuItem menuItem = fileMenu.getItem(i);
                if (menuItem == null || menuItem.getAction() != CubeModelRptDesigner.this.action_configure) continue;
                needAdd = false;
            }
            if (needAdd) {
                KDMenuItem item = new KDMenuItem((Action)CubeModelRptDesigner.this.action_configure);
                fileMenu.add((Component)item, 1);
            }
            return menuBar;
        }
    }
}

