/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport.layout;

import com.kingdee.bos.bi.model.common.bireport.layout.ChartComponent;
import com.kingdee.bos.bi.model.common.bireport.layout.Component;
import com.kingdee.bos.bi.model.common.bireport.layout.WorksheetComponent;
import com.kingdee.bos.bi.model.common.bireport.property.bean.BIReportBean;
import com.kingdee.bos.bi.model.ui.dialog.bireport.property.tree.AbstractBIReportContent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class BIReportComponents
implements Serializable {
    private List coms;
    private List beans;
    private BIReportBean rptProp;

    public BIReportComponents(BIReportBean rptProp, List beans) {
        this.rptProp = rptProp;
        this.beans = beans;
        this.convertToComponents();
    }

    public BIReportBean getReportBean() {
        return this.rptProp;
    }

    public List getComponentBeans() {
        return this.beans;
    }

    public List getComponents() {
        return this.coms;
    }

    private void convertToComponents() {
        int count = this.beans.size();
        for (int i = 0; i < count; ++i) {
            BIReportBean b;
            String type;
            if (this.coms == null) {
                this.coms = new ArrayList();
            }
            if ((type = (b = (BIReportBean)this.beans.get(i)).getType()).equalsIgnoreCase("chart")) {
                BIReportComponents.addComponent(b, this.coms, "Chart");
                continue;
            }
            if (!type.equalsIgnoreCase("worksheet")) continue;
            BIReportComponents.addComponent(b, this.coms, "Worksheet");
        }
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(this.rptProp.getType()).append(" ").append(this.rptProp.toSubXml()).append(">");
        int n = this.beans.size();
        for (int i = 0; i < n; ++i) {
            BIReportBean b = (BIReportBean)this.beans.get(i);
            sb.append("<").append(b.getType()).append(" ").append(b.toSubXml()).append("/>");
        }
        sb.append("</").append(this.rptProp.getType()).append(" >");
        return sb.toString();
    }

    private BIReportBean getBeanFromNode(DefaultKingdeeTreeNode node) {
        AbstractBIReportContent content = (AbstractBIReportContent)node.getUserObject();
        BIReportBean bean = content.getBean();
        return bean;
    }

    public static BIReportComponents fromElement(Element e) {
        Node ctNode;
        if (e == null) {
            return null;
        }
        BIReportBean bean = new BIReportBean("Component");
        BIReportComponents.loadProperties(e, bean);
        ArrayList<BIReportBean> list = new ArrayList<BIReportBean>();
        Node wsNode = e.selectSingleNode("Worksheet");
        if (wsNode != null) {
            BIReportBean wsBean = new BIReportBean("worksheet");
            BIReportComponents.loadProperties((Element)wsNode, wsBean);
            list.add(wsBean);
        }
        if ((ctNode = e.selectSingleNode("Chart")) != null) {
            BIReportBean ctBean = new BIReportBean("chart");
            BIReportComponents.loadProperties((Element)ctNode, ctBean);
            list.add(ctBean);
        }
        return new BIReportComponents(bean, list);
    }

    private static void loadProperties(Element e, BIReportBean bean) {
        List attrs = e.attributes();
        for (Attribute attr : attrs) {
            bean.setProp(attr.getName(), attr.getValue());
        }
    }

    private static void addComponent(BIReportBean bean, List components, String type) {
        String name = bean.getStringProp("name");
        String title = bean.getStringProp("title");
        Component wc = null;
        if ("Worksheet".equalsIgnoreCase(type)) {
            wc = new WorksheetComponent(name, title);
        } else if ("Chart".equalsIgnoreCase(type)) {
            wc = new ChartComponent(name, title);
        } else {
            return;
        }
        Map mapProps = bean.getProps();
        String[] keys = mapProps.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String v;
            String n = keys[i];
            if ("name".equalsIgnoreCase(n) || "title".equalsIgnoreCase(n) || (v = bean.getStringProp(n)) == null) continue;
            wc.setPropValue(n, v);
        }
        components.add(wc);
    }
}

