/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport.layout;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.layout.Axis;
import com.kingdee.bos.bi.model.common.bireport.layout.BIReportComponents;
import com.kingdee.bos.bi.model.common.bireport.layout.PageSetup;
import com.kingdee.bos.bi.model.common.bireport.layout.Slicer;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import java.io.Serializable;
import java.sql.SQLException;
import org.dom4j.Element;

public class BIReportLayout
implements Serializable {
    private PageSetup ps;
    private Axis rowAxis;
    private Axis colAxis;
    private Slicer slicer;
    private BIReportComponents components;
    private static final long serialVersionUID = 7806842577398422631L;

    public BIReportLayout(PageSetup ps, Axis rowAxis, Axis colAxis, Slicer slicer, BIReportComponents components) {
        this.ps = ps;
        this.rowAxis = rowAxis;
        this.colAxis = colAxis;
        this.slicer = slicer;
        this.components = components;
    }

    public PageSetup getPageSetup() {
        return this.ps;
    }

    public BIReportComponents getComponents() {
        return this.components;
    }

    public Slicer getSlicer() {
        return this.slicer;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Layout>");
        sb.append(this.ps.toXML());
        sb.append(this.rowAxis.toXML());
        sb.append(this.colAxis.toXML());
        sb.append(this.slicer.toXML());
        sb.append(this.components.toXML());
        sb.append("</Layout>");
        return sb.toString();
    }

    public static BIReportLayout fromElement(Element e, Context ctx, AppModel apm) throws SQLException {
        Axis rowAxis = Axis.fromElement((Element)e.selectSingleNode("Row"), true, ctx, apm);
        Axis colAxis = Axis.fromElement((Element)e.selectSingleNode("Col"), false, ctx, apm);
        Slicer slicer = Slicer.fromElement((Element)e.selectSingleNode("Slicer"), ctx, apm);
        BIReportComponents components = BIReportComponents.fromElement((Element)e.selectSingleNode("Component"));
        PageSetup ps = new PageSetup(components.getReportBean());
        return new BIReportLayout(ps, rowAxis, colAxis, slicer, components);
    }

    public Axis getRowAxis() {
        return this.rowAxis;
    }

    public Axis getColAxis() {
        return this.colAxis;
    }
}

