/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine;

import com.kingdee.bos.bi.model.common.formularengine.FormularEngine;
import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.IFuncExecutor;
import com.kingdee.bos.bi.model.common.formularengine.IVarValueProvider;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.exception.NonValueException;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormularChecker {
    private Set _existVarNames = new HashSet();
    private Map _refersFormulas = new HashMap();
    private boolean _isAllVarExist;
    private boolean _isFuncSupported;
    private Set _existFuncNames = new HashSet();

    public void setFuncSupported(boolean isFuncSupported) {
        this._isFuncSupported = isFuncSupported;
    }

    public void setAllVarExist(boolean isAllVarExist) {
        this._isAllVarExist = isAllVarExist;
    }

    public void addExistVarName(String varName) {
        this._existVarNames.add(varName);
    }

    public void addExistFuncName(String funcName) {
        this._existFuncNames.add(funcName);
    }

    public void clearExistVarNames() {
        this._existVarNames.clear();
    }

    public void clearExistFuncNames() {
        this._existFuncNames.clear();
    }

    public void addRefersFormula(String varName, AbstractExpr expr) {
        this._refersFormulas.put(varName, expr);
    }

    public void clearRefersFormulas() {
        this._refersFormulas.clear();
    }

    public boolean check(String formula, String dialogTitle, Component parentCtrl) {
        AbstractExpr expr;
        FormularParser parser = new FormularParser();
        try {
            expr = parser.parse(formula);
        }
        catch (StringParsingException e) {
            WindowUtil.msgboxWarning((Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + e.getMessage() + " \u3002"), (String)dialogTitle, (Component)parentCtrl);
            return false;
        }
        return this.check(expr, dialogTitle, parentCtrl);
    }

    public boolean check(AbstractExpr expr, String dialogTitle, Component parentCtrl) {
        FormularEngine engine = new FormularEngine();
        engine.setVarValueProvider(new VarValueProvider());
        try {
            engine.calculate(expr);
        }
        catch (NonValueException ex) {
            String number = ex.getNumber();
            WindowUtil.msgboxWarning((Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + "\u8282\u70b9\u201c" + number + "\u201d\u5f15\u7528\u7684\u201c" + ex.getVar() + "\u201d\u4e0d\u5b58\u5728\u3002"), (String)dialogTitle, (Component)parentCtrl);
            return false;
        }
        catch (FormulaComputingException ex) {
            WindowUtil.msgboxWarning((Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + ex.getMessage() + "\u3002" + StringUtil.RETURN + ex.getExpr().getExprString()), (String)dialogTitle, (Component)parentCtrl);
            return false;
        }
        return true;
    }

    public boolean checkFunc(AbstractExpr expr, String dialogTitle, Component parentCtrl) {
        FormularEngine engine = new FormularEngine();
        engine.setVarValueProvider(new VarValueProvider());
        try {
            engine.calculate(expr);
        }
        catch (NonValueException ex) {
            String number = ex.getNumber();
            return WindowUtil.msgboxYesNo((Component)parentCtrl, (Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + "\u53d6\u6570\u516c\u5f0f\u3010" + number + "\u3011\u4e2d\u7684\u3010" + ex.getVar() + "\u3011\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f"), (String)dialogTitle);
        }
        catch (FormulaComputingException ex) {
            return WindowUtil.msgboxYesNo((Component)parentCtrl, (Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + "\u53d6\u6570\u516c\u5f0f\u3010" + ex.getExpr().getExprString() + "\u3011\u4e2d\u7684" + ex.getMessage() + "\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f"), (String)dialogTitle);
        }
        return true;
    }

    private class VarValueProvider
    implements IVarValueProvider,
    IFuncExecutor {
        private VarValueProvider() {
        }

        @Override
        public AbstractExpr getFormula(String key) {
            key = this.takeoffBracket(key);
            return (AbstractExpr)FormularChecker.this._refersFormulas.get(key);
        }

        @Override
        public Variant getValue(String key) throws FormulaComputingException {
            if (FormularChecker.this._isAllVarExist) {
                return this.createRandomValue();
            }
            key = this.takeoffBracket(key);
            if (FormularChecker.this._existVarNames.contains(key)) {
                return this.createRandomValue();
            }
            return null;
        }

        private String takeoffBracket(String key) {
            if (key.startsWith("[") && key.endsWith("]")) {
                key = key.substring(1, key.length() - 1);
            }
            return key;
        }

        private Variant createRandomValue() {
            return new Variant((Object)BigDecimal.valueOf(Math.random() + 1.0));
        }

        @Override
        public Variant exec(String funcName, Variant[] paramValues) throws FormulaComputingException {
            if (FormularChecker.this._isFuncSupported) {
                if (FormularChecker.this._existFuncNames.contains(funcName)) {
                    return this.createRandomValue();
                }
                throw new FormulaComputingException("\u51fd\u6570\u540d\u3010" + funcName + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            throw new FormulaComputingException("\u4e0d\u652f\u6301\u51fd\u6570");
        }
    }
}

