/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.row.RowSecureMapping;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.EnumObj;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class FilterMappingDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = CommonLogger.getLogger(FilterMappingDialog.class);
    private KDComboBox cmbDataCenter;
    private KDComboBox cmbMappingTable;
    private KDComboBox cmbObject;
    private KDComboBox cmbColumn1;
    private KDComboBox cmbProp;
    private KDComboBox cmbColumn2;
    private KDScrollPane scrHelp;
    private KDTextArea txtHelp;
    private DimensionView dv;
    private IManagementFacade facade;
    private SecurityObjectType st;
    private boolean usedFlag;
    private boolean isAddItem = false;

    public FilterMappingDialog(Frame frame) {
        super(frame);
    }

    public FilterMappingDialog(Dialog dlg) {
        super(dlg);
    }

    public void setParameter(DimensionView dv, IManagementFacade facade, SecurityObjectType st, boolean usedFlag) {
        this.dv = dv;
        this.facade = facade;
        this.st = st;
        this.usedFlag = usedFlag;
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table table = thisCell.splitRow(4);
        table.rowStyle(0).lockHeight(50);
        table.rowStyle(0).setMarginBottom(30);
        table.rowStyle(1).lockHeight(25);
        table.rowStyle(1).setMarginBottom(5);
        table.rowStyle(2).lockHeight(30);
        table.rowStyle(2).setMarginBottom(10);
        Table tbl0 = table.cell(0).splitCol(2);
        KDLabelContainer lbcDataCenter = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbDataCenter, (String)"\u6570\u636e\u4e2d\u5fc3", (int)50);
        tbl0.cell(0).style().setMarginRight(5);
        parent.add((Component)lbcDataCenter, tbl0.cell(0));
        tbl0.colStyle(0).lockWidth(200);
        tbl0.colStyle(1).setMarginLeft(10);
        KDLabelContainer lbcMappingTable = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbMappingTable, (String)"\u6620\u5c04\u8868", (int)50);
        parent.add((Component)lbcMappingTable, tbl0.cell(1));
        Table tbl1 = table.cell(1).splitCol(2);
        KDLabelContainer lbcTarget = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbObject, (String)"\u9488\u5bf9", (int)50);
        tbl1.cell(0).style().setMarginRight(5);
        parent.add((Component)lbcTarget, tbl1.cell(0));
        this.cmbObject.setEnabled(false);
        tbl1.colStyle(0).lockWidth(200);
        tbl1.colStyle(1).setMarginLeft(10);
        KDLabelContainer lbcColumn1 = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbColumn1, (String)"\u5bf9\u5e94\u5217", (int)50);
        parent.add((Component)lbcColumn1, tbl1.cell(1));
        Table tbl2 = table.cell(2).splitCol(2);
        KDLabelContainer lbcProp = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbProp, (String)"\u5c5e\u6027", (int)50);
        tbl2.cell(0).style().setMarginRight(5);
        parent.add((Component)lbcProp, tbl2.cell(0));
        KDLabelContainer lbcColumn2 = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbColumn2, (String)"\u5bf9\u5e94\u5217", (int)50);
        parent.add((Component)lbcColumn2, tbl2.cell(1));
        tbl2.colStyle(0).lockWidth(200);
        tbl2.colStyle(1).setMarginLeft(10);
        parent.add((Component)this.scrHelp, table.cell(3));
        this.cmbObject.setSelectedItem((Object)this.st);
        this.loadDataCenters();
        List props = this.dv.getDimensionDef().getProperties();
        if (props != null) {
            this.cmbProp.addItems(props.toArray());
        }
        RowSecureMapping rsm = null;
        try {
            rsm = this.facade.getRowSecurityMapping(this.dv.getId(), this.st);
        }
        catch (SQLException e) {
            log.error((Object)"\u8bfb\u53d6\u6743\u9650\u6620\u5c04\u5b9a\u4e49\u65f6\u51fa\u9519", (Throwable)e);
        }
        if (rsm != null) {
            String centerId = rsm.getCenterId();
            if (centerId == null) {
                centerId = "";
            }
            int len = this.cmbDataCenter.getItemCount();
            for (int i = 0; i < len; ++i) {
                EnumObj obj = (EnumObj)this.cmbDataCenter.getItemAt(i);
                if (!obj.getNumber().equals(centerId)) continue;
                this.cmbDataCenter.setSelectedIndex(i);
                break;
            }
            String mappingTable = rsm.getMapTable();
            this.cmbMappingTable.setSelectedItem((Object)mappingTable);
            String objColumn = rsm.getMapObjColumn();
            int len2 = this.cmbColumn1.getItemCount();
            for (int i = 0; i < len2; ++i) {
                Column col = (Column)this.cmbColumn1.getItemAt(i);
                if (!col.getName().equals(objColumn)) continue;
                this.cmbColumn1.setSelectedIndex(i);
                break;
            }
            String attr = rsm.getFilterAttr();
            int len3 = this.cmbProp.getItemCount();
            for (int i = 0; i < len3; ++i) {
                Property prop = (Property)this.cmbProp.getItemAt(i);
                if (!prop.getName().equals(attr)) continue;
                this.cmbProp.setSelectedIndex(i);
                break;
            }
            String attrColumn = rsm.getMapAtrColumn();
            int len4 = this.cmbColumn2.getItemCount();
            for (int i = 0; i < len4; ++i) {
                Column col = (Column)this.cmbColumn2.getItemAt(i);
                if (!col.getName().equals(attrColumn)) continue;
                this.cmbColumn2.setSelectedIndex(i);
                break;
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("    \u8be5\u6620\u5c04\u9488\u5bf9\u5f53\u524d\u4e0a\u4e0b\u6587\u7684");
        sb.append(this.st.getAlias());
        sb.append("\uff0c\u5373\u6267\u884c\u65f6\u7684\u5f53\u524d");
        sb.append(this.st.getAlias());
        sb.append("\u4f7f\u7528\u5916\u52a0\u7684\u6620\u5c04\u8868\u6765\u6620\u5c04");
        sb.append(this.st.getAlias());
        sb.append("\u4ee5\u53ca\u7ef4\u5ea6\u7684\u5c5e\u6027\u5b57\u6bb5\u3002");
        this.txtHelp.setText(sb.toString());
    }

    private void loadDataCenters() {
        this.cmbDataCenter.removeAllItems();
        List dcs = null;
        try {
            dcs = this.facade.getDBCenterList();
            this.isAddItem = true;
            this.cmbDataCenter.addItems(dcs.toArray());
            this.isAddItem = false;
            this.loadTables();
        }
        catch (SQLException e) {
            log.error((Object)"\u88c5\u8f7d\u53ef\u7528\u7684\u6570\u636e\u4e2d\u5fc3\u65f6\u51fa\u9519", (Throwable)e);
        }
        catch (DBCenterException e) {
            log.error((Object)"\u88c5\u8f7d\u53ef\u7528\u7684\u6570\u636e\u4e2d\u5fc3\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    private void loadTables() {
        this.cmbMappingTable.removeAllItems();
        EnumObj cur = (EnumObj)this.cmbDataCenter.getSelectedItem();
        if (cur != null) {
            List lstTable = null;
            try {
                lstTable = this.facade.getDBCenterTables(cur.getNumber());
                this.isAddItem = true;
                this.cmbMappingTable.addItems(lstTable.toArray());
                this.isAddItem = false;
                this.cmbMappingTable.setSelectedIndex(0);
                this.loadColumns();
            }
            catch (SQLException e) {
                log.error((Object)"\u88c5\u8f7d\u6570\u636e\u4e2d\u5fc3\u7684\u8868\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private void loadColumns() {
        String table = (String)this.cmbMappingTable.getSelectedItem();
        EnumObj dc = (EnumObj)this.cmbDataCenter.getSelectedItem();
        this.cmbColumn1.removeAllItems();
        this.cmbColumn2.removeAllItems();
        if (!StringUtils.isEmpty((String)table) && dc != null) {
            List lstColumn = null;
            try {
                String tableSql = "select * from " + table;
                lstColumn = this.facade.getColumnsFromDBCenter(dc.getNumber(), tableSql);
                this.cmbColumn1.addItems(lstColumn.toArray());
                this.cmbColumn2.addItems(lstColumn.toArray());
            }
            catch (SQLException e) {
                log.error((Object)"\u88c5\u8f7d\u8868\u7684\u5217\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
    }

    protected void todoInit() {
        this.cmbDataCenter = new KDComboBox();
        this.cmbDataCenter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FilterMappingDialog.this.isAddItem) {
                    FilterMappingDialog.this.loadTables();
                }
            }
        });
        this.cmbMappingTable = new KDComboBox();
        this.cmbMappingTable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FilterMappingDialog.this.isAddItem) {
                    FilterMappingDialog.this.loadColumns();
                }
            }
        });
        this.cmbObject = new KDComboBox();
        this.cmbObject.addItem((Object)SecurityObjectType.user);
        this.cmbObject.addItem((Object)SecurityObjectType.org);
        this.cmbColumn1 = new KDComboBox();
        this.cmbColumn2 = new KDComboBox();
        this.cmbProp = new KDComboBox();
        this.txtHelp = new KDTextArea("");
        this.scrHelp = new KDScrollPane((Component)this.txtHelp);
        this.scrHelp.setVerticalScrollBarPolicy(20);
        this.txtHelp.setEditable(false);
    }

    protected boolean verify() {
        if (this.cmbDataCenter.getSelectedItem() == null) {
            WindowUtil.msgboxWarning((Object)"\u672a\u9009\u62e9\u6570\u636e\u4e2d\u5fc3", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        if (this.cmbMappingTable.getSelectedItem() == null) {
            WindowUtil.msgboxWarning((Object)"\u672a\u9009\u62e9\u6620\u5c04\u8868", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        if (this.cmbColumn1.getSelectedItem() == null) {
            WindowUtil.msgboxWarning((Object)"\u672a\u9009\u62e9\u5bf9\u8c61\u6620\u5c04\u5217", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        if (this.cmbProp.getSelectedItem() == null) {
            WindowUtil.msgboxWarning((Object)"\u672a\u9009\u62e9\u5c5e\u6027", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        if (this.cmbColumn2.getSelectedItem() == null) {
            WindowUtil.msgboxWarning((Object)"\u672a\u9009\u62e9\u5c5e\u6027\u6620\u5c04\u5217", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        return true;
    }

    public void save() {
        String centerId = ((EnumObj)this.cmbDataCenter.getSelectedItem()).getNumber();
        String mapTablename = this.cmbMappingTable.getSelectedItem().toString();
        String mapObjColumn = ((Column)this.cmbColumn1.getSelectedItem()).getName();
        String filterAttr = ((Property)this.cmbProp.getSelectedItem()).getName();
        String mapAttrColumn = ((Column)this.cmbColumn2.getSelectedItem()).getName();
        String view_id = this.dv.getId();
        RowSecureMapping rsm = new RowSecureMapping(centerId, mapTablename, this.st, mapObjColumn, filterAttr, mapAttrColumn, view_id, this.usedFlag);
        try {
            this.facade.saveRowSecurityMapping(rsm);
        }
        catch (SQLException e) {
            String errMsg = "\u4fdd\u5b58\u6620\u5c04\u5b9a\u4e49\u5931\u8d25!";
            log.error((Object)errMsg, (Throwable)e);
            WindowUtil.msgboxError((Object)errMsg, (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
        }
    }
}

