/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.ui.content.AbstractCSTMLeafViewUI;
import com.kingdee.bos.bi.model.ui.dialog.time.TimeDimensionDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import java.awt.Component;
import java.sql.SQLException;

public class TimeDimensionUI
extends AbstractCSTMLeafViewUI {
    public TimeDimensionUI(String caption, String id, String dimensionType) {
        super(caption, id, dimensionType);
    }

    @Override
    public String getViewType() {
        return "time";
    }

    @Override
    protected void viewDetail(int rowIdx) {
        String operator = "\u67e5\u770b";
        String viewId = this.getRowID(rowIdx);
        String viewName = this.getRowName(rowIdx);
        this.checkCustonDefineDimensionIdExist(viewId, viewName);
        TimeModel m = this.loadModel(viewId, viewName, operator);
        this.innerEdit(viewId, viewName, operator, true, m);
    }

    @Override
    protected void doEdit(String viewId, String viewName) {
        String operator = "\u7f16\u8f91";
        TimeModel m = this.loadModel(viewId, viewName, operator);
        this.innerEdit(viewId, viewName, operator, false, m);
    }

    private TimeModel loadModel(String viewId, String viewName, String operator) {
        TimeModel m = null;
        try {
            m = TimeModel.load(this.getManFacade(), viewId, this.getDimId());
            m.setDescription(this.getManFacade().loadViewDiscription(this.getViewType(), viewId));
        }
        catch (BIModelRemoteException e) {
            log.error((Object)"", (Throwable)((Object)e));
            WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u8bfb\u53d6\u5185\u5bb9\u3002" + e.getMessage()), (String)this.createTitle(operator, viewName), (Component)this.getRootCtrl());
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return m;
    }

    @Override
    protected boolean innerEdit(String viewId, String viewName, String operator, boolean isReadOnly, Object param) {
        TimeModel t = (TimeModel)param;
        TimeDimensionDialog dlg = (TimeDimensionDialog)((Object)WindowUtil.createWindow(TimeDimensionDialog.class, (Component)((Object)this.getTable())));
        dlg.setTitle(this.createTitle(operator, viewName));
        dlg.setModel(t);
        dlg.setReadOnly(isReadOnly);
        if (dlg.showDialog()) {
            try {
                TimeModel.save(this.getManFacade(), viewId, dlg.getModel(), this.getDimId());
                this.getManFacade().updateViewDiscription(this.getViewType(), viewId, dlg.getDiscriptionTxt().trim());
            }
            catch (BIModelRemoteException e) {
                WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u4fdd\u5b58\u5185\u5bb9\uff1a" + e.getMessage()), (String)dlg.getTitle(), (Component)this.getRootCtrl());
                log.error((Object)"", (Throwable)((Object)e));
                return false;
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
            return true;
        }
        return false;
    }
}

