/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.SqlWithParamTableDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.PermissionDef;
import com.kingdee.bos.olap.def.PermissionItemDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaLoader;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.util.SqlParamSet;
import com.kingdee.bos.olap.util.SqlWithParam;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.bireport.BireportException;
import com.kingdee.eas.framework.bireport.app.AbstractBireportBaseFacadeControllerBean;
import com.kingdee.eas.framework.bireport.app.IORMRPCBIOlapService;
import com.kingdee.eas.framework.bireport.app.ORMRPCBIOlapService;
import com.kingdee.eas.framework.bireport.app.schema.SchemaManager;
import com.kingdee.eas.framework.bireport.app.servo.OlapConnectionServo;
import com.kingdee.eas.framework.bireport.util.BIDataPermission;
import com.kingdee.eas.framework.bireport.util.BIReportException;
import com.kingdee.eas.framework.bireport.util.BenchmarkTimer;
import com.kingdee.eas.framework.bireport.util.BireportDBUtil;
import com.kingdee.eas.framework.bireport.util.OlapParams;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.config.UserCustomConfigFactory;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.JDOMFactory;

public class BireportBaseFacadeControllerBean
extends AbstractBireportBaseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.app.BireportBaseFacadeControllerBean");
    private static final String BIOLAP_SERVER_LOCATION = "BIOLAP";

    @Override
    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    protected Map prepareUIInfo(Context ctx, Map uiParams) throws BOSException, EASBizException {
        return null;
    }

    protected boolean appendFilter(String fieldName, String[] values, StringBuffer sql, SqlParams sp, String op) {
        if (values == null || values.length == 0) {
            return false;
        }
        if (values.length == 1) {
            sql.append(' ').append(op).append(' ').append(fieldName).append("=?");
            sp.addString(values[0]);
        } else {
            sql.append(' ').append(op).append(' ').append(fieldName).append(" in(");
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                sql.append('?');
                sp.addString(values[i]);
                if (i == n - 1) continue;
                sql.append(',');
            }
            sql.append(')');
        }
        return true;
    }

    private Object makeTableParam(String name, SchemaSource.DataItem dataItem, PermissionDef permission, RptParams params, Context ctx) throws SQLException, EASBizException, BOSException {
        String sql = dataItem.getSql();
        if (sql != null && permission != null) {
            int n = permission.items.length;
            StringBuffer s = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < n; ++i) {
                PermissionItemDef item = permission.items[i];
                if (!item.type.equalsIgnoreCase("SQL_FILTER")) continue;
                if (first) {
                    first = false;
                    s.append("select * from (").append(sql).append(") where ");
                } else {
                    s.append(" and ");
                }
                s.append(BIDataPermission.getPermissionWhereSQL(item.name, params, item.column, ctx));
            }
            sql = s.toString();
        }
        SqlWithParam sqlWithParam = new SqlWithParam();
        sqlWithParam.sql = sql;
        if (dataItem.getSp() != null) {
            sqlWithParam.sp = new SqlParamSet(dataItem.getSp().getParams());
        }
        return new SqlWithParamTableDef(name, sqlWithParam);
    }

    @Override
    protected OlapParams _etlModel(Context ctx, RptParams params, boolean remoteConnection, int caller) throws BOSException, EASBizException {
        BenchmarkTimer.enable(true);
        OlapParams olapParams = new OlapParams();
        boolean shouldCloseFirst = params.getBoolean("OLAP_KEY_SHOULDCLOSEFIRST");
        if (shouldCloseFirst) {
            this._invokeConnectionAction(ctx, "close", null, null, caller);
        }
        boolean useNonEmpty = params.getBoolean("useNonEmpty");
        boolean nonEmptyForRow = params.getBoolean("nonEmptyForRow");
        boolean nonEmptyForColumn = params.getBoolean("nonEmptyForColumn");
        Map uiParams = (Map)params.getObject("OLAP_KEY_UIPARAMS");
        if (uiParams != null) {
            Map uiInfo = this.prepareUIInfo(ctx, uiParams);
            olapParams.setObject("OLAP_KEY_UIINFO", uiInfo);
        }
        IObjectPK pk = (IObjectPK)params.getObject("OLAP_KEY_PK");
        UserCustomConfigInfo userConfigInfo = UserCustomConfigFactory.getLocalInstance((Context)ctx).getValue(pk);
        olapParams.setObject("OLAP_KEY_USERCUSTOMCONFIG", userConfigInfo);
        BenchmarkTimer.startTime("readySchemaSource cost");
        SchemaSource ss = this.readySchemaSource(params, ctx);
        BenchmarkTimer.stopTime();
        InputStream is = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            is = this.loadSchema(ss.getFilename(), ss.getMacroMap(), ss.getCaller(), ctx);
            SchemaDef schemaDef = SchemaLoader.load((InputStream)is);
            ArrayList<String> notVisibleMeasures = new ArrayList<String>();
            MeasureDef[] measures = schemaDef.cubes[0].measures;
            for (int i = 0; i < measures.length; ++i) {
                if (measures[i].permission == null) continue;
                boolean hasPermission = true;
                PermissionItemDef[] items = measures[i].permission.items;
                for (int j = 0; j < items.length && (!items[j].type.equalsIgnoreCase("BOOLEAN") || (hasPermission = BIDataPermission.hasFunctionPermission(items[j].name, params, ctx))); ++j) {
                }
                if (hasPermission) continue;
                notVisibleMeasures.add(measures[i].name);
            }
            SharedDimensionDef[] dims = schemaDef.dimensions;
            HashMap<String, PermissionDef> perDimTables = new HashMap<String, PermissionDef>();
            for (int i = 0; i < dims.length; ++i) {
                if (dims[i].permission == null) continue;
                perDimTables.put(dims[i].table, dims[i].permission);
            }
            Set keySet = ss.getDataMap().keySet();
            Object[] keys = new Object[keySet.size()];
            keySet.toArray(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object value = ss.getDataMap().get(keys[i]);
                if (!(value instanceof SchemaSource.DataItem)) continue;
                SchemaSource.DataItem dataItem = (SchemaSource.DataItem)value;
                PermissionDef per = (PermissionDef)perDimTables.get(keys[i]);
                Object tableParam = this.makeTableParam((String)keys[i], dataItem, per, params, ctx);
                ss.getDataMap().put(keys[i], tableParam);
            }
            olapParams.putAll(ss.getProperties().toMap());
            olapParams.setMdx(ss.getMdx());
            olapParams.setFiltString(ss.getFilterString());
            OlapParams olapParams2 = olapParams = this.getORMRPCBosObject()._executeModel(ss.getDataMap(), ss.getFilterString(), ss.getMdx(), notVisibleMeasures, schemaDef, this.useSQLDataReduction(), olapParams, useNonEmpty, nonEmptyForRow, nonEmptyForColumn, ctx, params, remoteConnection, caller);
            return olapParams2;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (UnsupportedOperationException e) {
            OLAPException oe = new OLAPException(e.getMessage());
            BIReportException be = new BIReportException(oe);
            throw be;
        }
        catch (OLAPException e) {
            BIReportException be = new BIReportException(e);
            throw be;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof OlapException) {
                throw new BIReportException(e.getCause());
            }
            logger.error((Object)e, e.getCause());
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
    }

    @Override
    protected IRowSet _executeQuery(Context ctx, String sql, SqlParams sp) throws BOSException, EASBizException {
        try {
            return BireportDBUtil.executeQuery(sql, sp, ctx);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected int _executeUpdate(Context ctx, String sql, SqlParams sp) throws BOSException, EASBizException {
        try {
            return BireportDBUtil.executeUpdate(sql, sp, ctx);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static int executeSelectInto(String sql, SqlParams pp, Context ctx) throws SQLDataException {
        try {
            return DBUtilx.executeSelectInto((String)sql, (SqlParams)pp, (Context)ctx);
        }
        catch (Exception e) {
            throw new SQLDataException("SQL Execute error:" + sql, (Throwable)e);
        }
    }

    public static String getTempTableName(String desc, Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    public static void dropTempTable(String tempTableName, Context ctx) throws BOSException {
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tempTableName);
    }

    public static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected Object _invokeConnectionAction(Context ctx, String method, Class[] argTypes, Object[] argValues, int caller) throws BOSException, EASBizException {
        return this.getORMRPCBosObject()._invokeConnectionAction(ctx, method, argTypes, argValues, caller);
    }

    protected Connection registConnection(Connection con, int uiCaller, Context ctx) throws OLAPException, EASBizException {
        OlapConnectionServo cm = OlapConnectionServo.getInstance();
        cm.remove(ctx, uiCaller, true);
        cm.put(ctx, uiCaller, con);
        return con;
    }

    protected boolean useRolap() {
        return true;
    }

    protected boolean useSQLDataReduction() {
        return false;
    }

    private InputStream loadSchema(String xmlFile, Map macroMap, Class loaderClass, Context ctx) throws EASBizException {
        String clPath = loaderClass.getName();
        String shortName = clPath.substring(clPath.lastIndexOf(46) + 1);
        String interfaceName = 'I' + shortName.substring(0, shortName.length() - "ControllerBean".length());
        String interfacePath = clPath.substring(0, clPath.length() - shortName.length() - "app.".length()) + interfaceName;
        InputStream is = null;
        try {
            int dotIndex = xmlFile.lastIndexOf(46);
            String localXmlFile = xmlFile.substring(0, dotIndex) + '_' + BireportBaseFacadeControllerBean.getLoc(ctx).toUpperCase() + xmlFile.substring(dotIndex);
            is = Class.forName(interfacePath).getResourceAsStream("config/" + localXmlFile);
            if (is == null) {
                is = Class.forName(interfacePath).getResourceAsStream("config/" + xmlFile);
            }
            SchemaManager sm = new SchemaManager(macroMap, ctx.getLocale());
            is = sm.transSchema(is, "UTF-8");
            return is;
        }
        catch (Exception e) {
            logger.error((Object)BireportException.LOAD_SCHEMADEF_ERROR, (Throwable)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            throw new BireportException(BireportException.SELF_INFO, e, new Object[]{sw.toString()});
        }
    }

    protected java.sql.Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return DBUtilx.getConnection((Context)ctx, (int)1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getORMRPCServerURL() throws BOSException {
        ORMServiceLocation loc = new ORMServiceLocation(BIOLAP_SERVER_LOCATION);
        if (loc == null) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!");
        }
        try {
            return loc.getServiceURL();
        }
        catch (Exception err) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!", (Throwable)err);
        }
    }

    private IORMRPCBIOlapService getORMRPCBosObject() throws BOSException {
        String url = this.getORMRPCServerURL();
        ORMRPCBIOlapService bosObject = null;
        bosObject = url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1") ? new ORMRPCBIOlapService() : RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.framework.bireport.app.ORMRPCBIOlapService", IORMRPCBIOlapService.class);
        return bosObject;
    }
}

